% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeoptimizer_operations.R
\name{computeoptimizer_update_enrollment_status}
\alias{computeoptimizer_update_enrollment_status}
\title{Updates the enrollment (opt in and opt out) status of an account to the
Compute Optimizer service}
\usage{
computeoptimizer_update_enrollment_status(status, includeMemberAccounts = NULL)
}
\arguments{
\item{status}{[required] The new enrollment status of the account.

The following status options are available:
\itemize{
\item \code{Active} - Opts in your account to the Compute Optimizer service.
Compute Optimizer begins analyzing the configuration and utilization
metrics of your Amazon Web Services resources after you opt in. For
more information, see \href{https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html}{Metrics analyzed by Compute Optimizer}
in the \emph{Compute Optimizer User Guide}.
\item \code{Inactive} - Opts out your account from the Compute Optimizer
service. Your account's recommendations and related metrics data
will be deleted from Compute Optimizer after you opt out.
}

The \code{Pending} and \code{Failed} options cannot be used to update the
enrollment status of an account. They are returned in the response of a
request to update the enrollment status of an account.}

\item{includeMemberAccounts}{Indicates whether to enroll member accounts of the organization if the
account is the management account of an organization.}
}
\description{
Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.

See \url{https://paws-r.github.io/docs/computeoptimizer/update_enrollment_status.html} for full documentation.
}
\keyword{internal}
