% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_image}
\alias{ec2_create_image}
\title{Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that
is either running or stopped}
\usage{
ec2_create_image(
  BlockDeviceMappings = NULL,
  Description = NULL,
  DryRun = NULL,
  InstanceId,
  Name,
  NoReboot = NULL,
  TagSpecifications = NULL
)
}
\arguments{
\item{BlockDeviceMappings}{The block device mappings. This parameter cannot be used to modify the
encryption status of existing volumes or snapshots. To create an AMI
with encrypted snapshots, use the \code{\link[=ec2_copy_image]{copy_image}} action.}

\item{Description}{A description for the new image.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceId}{[required] The ID of the instance.}

\item{Name}{[required] A name for the new image.

Constraints: 3-128 alphanumeric characters, parentheses (()), square
brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-),
single quotes ('), at-signs (@), or underscores(_)}

\item{NoReboot}{By default, when Amazon EC2 creates the new AMI, it reboots the instance
so that it can take snapshots of the attached volumes while data is at
rest, in order to ensure a consistent state. You can set the \code{NoReboot}
parameter to \code{true} in the API request, or use the \code{--no-reboot} option
in the CLI to prevent Amazon EC2 from shutting down and rebooting the
instance.

If you choose to bypass the shutdown and reboot process by setting the
\code{NoReboot} parameter to \code{true} in the API request, or by using the
\code{--no-reboot} option in the CLI, we can't guarantee the file system
integrity of the created image.

Default: \code{false} (follow standard reboot process)}

\item{TagSpecifications}{The tags to apply to the AMI and snapshots on creation. You can tag the
AMI, the snapshots, or both.
\itemize{
\item To tag the AMI, the value for \code{ResourceType} must be \code{image}.
\item To tag the snapshots that are created of the root volume and of
other Amazon EBS volumes that are attached to the instance, the
value for \code{ResourceType} must be \code{snapshot}. The same tag is applied
to all of the snapshots that are created.
}

If you specify other values for \code{ResourceType}, the request fails.

To tag an AMI or snapshot after it has been created, see
\code{\link[=ec2_create_tags]{create_tags}}.}
}
\description{
Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.

See \url{https://paws-r.github.io/docs/ec2/create_image.html} for full documentation.
}
\keyword{internal}
