% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_identity_id_format}
\alias{ec2_describe_identity_id_format}
\title{Describes the ID format settings for resources for the specified IAM
user, IAM role, or root user}
\usage{
ec2_describe_identity_id_format(PrincipalArn, Resource = NULL)
}
\arguments{
\item{PrincipalArn}{[required] The ARN of the principal, which can be an IAM role, IAM user, or the
root user.}

\item{Resource}{The type of resource: \code{bundle} | \code{conversion-task} | \code{customer-gateway}
| \code{dhcp-options} | \code{elastic-ip-allocation} | \code{elastic-ip-association} |
\code{export-task} | \code{flow-log} | \code{image} | \code{import-task} | \code{instance} |
\code{internet-gateway} | \code{network-acl} | \code{network-acl-association} |
\code{network-interface} | \code{network-interface-attachment} | \code{prefix-list} |
\code{reservation} | \code{route-table} | \code{route-table-association} |
\code{security-group} | \code{snapshot} | \code{subnet} |
\code{subnet-cidr-block-association} | \code{volume} | \code{vpc} |
\code{vpc-cidr-block-association} | \code{vpc-endpoint} | \code{vpc-peering-connection}
| \code{vpn-connection} | \code{vpn-gateway}}
}
\description{
Describes the ID format settings for resources for the specified IAM user, IAM role, or root user. For example, you can view the resource types that are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html}{Resource IDs} in the \emph{Amazon Elastic Compute Cloud User Guide}.

See \url{https://paws-r.github.io/docs/ec2/describe_identity_id_format.html} for full documentation.
}
\keyword{internal}
