% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_flow_logs_integration_template}
\alias{ec2_get_flow_logs_integration_template}
\title{Generates a CloudFormation template that streamlines and automates the
integration of VPC flow logs with Amazon Athena}
\usage{
ec2_get_flow_logs_integration_template(
  DryRun = NULL,
  FlowLogId,
  ConfigDeliveryS3DestinationArn,
  IntegrateServices
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{FlowLogId}{[required] The ID of the flow log.}

\item{ConfigDeliveryS3DestinationArn}{[required] To store the CloudFormation template in Amazon S3, specify the location
in Amazon S3.}

\item{IntegrateServices}{[required] Information about the service integration.}
}
\description{
Generates a CloudFormation template that streamlines and automates the integration of VPC flow logs with Amazon Athena. This make it easier for you to query and gain insights from VPC flow logs data. Based on the information that you provide, we configure resources in the template to do the following:

See \url{https://paws-r.github.io/docs/ec2/get_flow_logs_integration_template.html} for full documentation.
}
\keyword{internal}
