% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_update_function_url_config}
\alias{lambda_update_function_url_config}
\title{Updates the configuration for a Lambda function URL}
\usage{
lambda_update_function_url_config(
  FunctionName,
  Qualifier = NULL,
  AuthType = NULL,
  Cors = NULL
)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Qualifier}{The alias name.}

\item{AuthType}{The type of authentication that your function URL uses. Set to \code{AWS_IAM}
if you want to restrict access to authenticated \code{IAM} users only. Set to
\code{NONE} if you want to bypass IAM authentication to create a public
endpoint. For more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html}{Security and auth model for Lambda function URLs}.}

\item{Cors}{The \href{https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS}{cross-origin resource sharing (CORS)} settings
for your function URL.}
}
\description{
Updates the configuration for a Lambda function URL.

See \url{https://paws-r.github.io/docs/lambda/update_function_url_config.html} for full documentation.
}
\keyword{internal}
