% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_describe_backups}
\alias{fsx_describe_backups}
\title{Returns the description of specific Amazon FSx backups, if a BackupIds
value is provided for that backup}
\usage{
fsx_describe_backups(BackupIds, Filters, MaxResults, NextToken)
}
\arguments{
\item{BackupIds}{IDs of the backups you want to retrieve (String). This overrides any
filters. If any IDs are not found, BackupNotFound will be thrown.}

\item{Filters}{Filters structure. Supported names are file-system-id and backup-type.}

\item{MaxResults}{Maximum number of backups to return in the response (integer). This
parameter value must be greater than 0. The number of items that Amazon
FSx returns is the minimum of the \code{MaxResults} parameter specified in
the request and the service\'s internal maximum number of items per
page.}

\item{NextToken}{Opaque pagination token returned from a previous \code{DescribeBackups}
operation (String). If a token present, the action continues the list
from where the returning call left off.}
}
\description{
Returns the description of specific Amazon FSx backups, if a \code{BackupIds}
value is provided for that backup. Otherwise, it returns all backups
owned by your AWS account in the AWS Region of the endpoint that you\'re
calling.
}
\details{
When retrieving all backups, you can optionally specify the \code{MaxResults}
parameter to limit the number of backups in a response. If more backups
remain, Amazon FSx returns a \code{NextToken} value in the response. In this
case, send a later request with the \code{NextToken} request parameter set to
the value of \code{NextToken} from the last response.

This action is used in an iterative process to retrieve a list of your
backups. \code{DescribeBackups} is called first without a \code{NextToken}value.
Then the action continues to be called with the \code{NextToken} parameter
set to the value of the last \code{NextToken} value until a response has no
\code{NextToken}.

When using this action, keep the following in mind:
\itemize{
\item The implementation might return fewer than \code{MaxResults} file system
descriptions while still including a \code{NextToken} value.
\item The order of backups returned in the response of one
\code{DescribeBackups} call and the order of backups returned across the
responses of a multi-call iteration is unspecified.
}
}
\section{Request syntax}{
\preformatted{svc$describe_backups(
  BackupIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "file-system-id"|"backup-type"|"file-system-type",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\examples{
\dontrun{
# This operation describes all of the Amazon FSx backups in an account.
svc$describe_backups()
}

}
\keyword{internal}
