% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateAUC.R
\name{simulateAUC}
\alias{simulateAUC}
\title{Simulate Area Under the ROC Curve (AUC).}
\usage{
simulateAUC(auc, n)
}
\arguments{
\item{auc}{The area under the receiver operating characteristic (ROC) curve.}

\item{n}{The number of observations to simulate.}
}
\value{
Dataframe with two columns:
\itemize{
  \item \code{x} is the predictor variable.
  \item \code{y} is the dichotomous criterion variable.
}
}
\description{
Simulate data with a specified area under the receiver operating
characteristic curve—i.e., the AUC of an ROC curve.
}
\details{
Simulates data with a specified area under the receiver operating
characteristic curve—i.e., the AUC of an ROC curve.
}
\examples{
simulateAUC(.60, 50000)
simulateAUC(.70, 50000)
simulateAUC(.80, 50000)
simulateAUC(.90, 50000)
simulateAUC(.95, 50000)
simulateAUC(.99, 50000)

}
\seealso{
\url{https://stats.stackexchange.com/questions/422926/generate-synthetic-data-given-auc/424213}

Other simulation: 
\code{\link{complement}()},
\code{\link{simulateIndirectEffect}()}
}
\concept{simulation}
