% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{rtma_cdf}
\alias{rtma_cdf}
\title{Compute theoretical and empirical CDFs for a right-truncated meta-analysis}
\usage{
rtma_cdf(rtma)
}
\arguments{
\item{rtma}{Output of \code{phacking_rtma()}.}
}
\value{
A tibble with the columns \code{yi} (effect sizes), \code{cdfi}
(their fitted CDF) and \code{ecdfi} (their empirical CDF).
}
\description{
Compute theoretical and empirical CDFs for a right-truncated meta-analysis
}
\examples{
\donttest{
set.seed(22)
lodder_rtma <- phacking_rtma(lodder$yi, lodder$vi, parallelize = FALSE)
rtma_cdf(lodder_rtma)
}
}
\references{
\insertRef{mathur2022}{phacking}
}
