\name{summary.bayesplfm}
\alias{summary.bayesplfm}
\title{
Summarizing Bayesian probabilistic latent feature analysis
}
\description{
The function \code{\link{summary.bayesplfm}} summarizes the output of the object generated by the 
 \code{\link{bayesplfm}} function.
}
\usage{
\method{summary}{bayesplfm}(object, \dots)
}
\arguments{
  \item{object}{Bayesian probabilistic latent feature analysis object returned by \code{\link{bayesplfm}}}
  \item{\dots}{Further arguments are ignored}
}
\details{
The summary of the Bayesian probabilistic latent feature analysis objects displays:
\enumerate{ 
\item The parameters used to call the \code{\link{bayesplfm}} function.
\item Information on the descriptive fit of the model (i.e. correlation between observed and expected frequencies,
      and proportion of the variance in the observed frequencies accounted for by the model).
\item The posterior mean of the object- and attribute parameters.
\item 95 percent posterior intervals for the object- and attribute parameters.
\item Rhat convergence values for object- and attribute parameters (if \code{Nchains}>1).
}
}
\value{
  \item{call}{Parameters used to call the function.}
  \item{descriptivefit}{A list with two measures of descriptive fit on the \emph{J X K} table: (1) the correlation 
   between observed and expected frequencies, and (2) the proportion of the variance 
   in the observed frequencies accounted for by the model. }
  \item{objpar}{A \emph{J X F} matrix with the posterior mean of the object parameters computed on all iterations and chains in the sample.}
  \item{attpar}{A \emph{K X F} matrix with the posterior mean of the attribute parameters computed on all iterations and chains in the sample.}
  \item{p95objpar}{95 percent posterior intervals of object parameters.}
  \item{p95attpar}{95 percent posterior intervals of attribute parameters.}
  \item{Rhatobjpar}{Rhat convergence values for object parameters.}
  \item{Rhatattpar}{Rhat convergence values for attribute parameters.}
}
\seealso{
\code{\link{bayesplfm}}
}
\examples{
\dontrun{

##load car data
data(car)

## compute 5 runs of disjunctive model with 2 features
carem2<-plfm(maprule="disj",freq1=car$freq1,freqtot=car$freqtot,F=2,M=5)

## Compute a sample of the posterior distribution 
## for the disjunctive model with two features
## use the posterior mode obtained with the previous plfm analysis
carbayes2<-bayesplfm(maprule="disj",freq1=car$freq1,freqtot=car$freqtot,F=2,
                      maxNiter=500,Nburnin=0,Nstep=100,Nchains=2,
                      start.bayes="fitted.plfm",fitted.plfm=carem2)


## compute a summary of the object generated by bayesplfm
summarycarbayes2<-summary(carbayes2)
}
}