% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{data}
\name{pliman_images}
\alias{pliman_images}
\title{Sample images}
\format{
\verb{*.jpg} format
\itemize{
\item \code{flax_leaves.jpg} Flax leaves in a white background
\item \code{flax_grains.jpg} Flax grains with background light.
\item \code{la_back.jpg} A cyan palette representing the background of images
la_pattern, la_leaves, and soybean_touch.
\item \code{la_leaf.jpg} A sample of the leaves in \code{la_leaves}
\item \code{la_leaves.jpg} Tree leaves with a sample of known area.
\item \code{mult_leaves.jpg} Three soybean leaflets with soybean rust symptoms.
\item \code{objects_300dpi.jpg} An image with 300 dpi resolution.
\item \code{potato_leaves.jpg} Three potato leaves, which were gathered from Gupta et
al. (2020).
\item \code{sev_leaf.jpg} A soybean leaf with a blue background.
\item \code{sev_leaf_nb.jpg} A soybean leaf without background.
\item \code{sev_back.jpg} A blue palette representing the background of \code{sev_leaf}.
\item \code{sev_healthy.jpg} Healthy area of \code{sev_leaf}.
\item \code{sev_sympt.jpg} The symptomatic area \code{sev_leaf}.
\item \code{shadow.jpg} A shaded leaf, useful to test adaptive thresholding
\item \code{soy_green.jpg} Soybean grains with a white background.
\item \code{soybean_grain.jpg} A sample palette of the grains in \code{soy_green}.
\item \code{soybean_touch.jpg} Soybean grains with a cyan background touching one each
other.
\item \code{field_mosaic.jpg} An UVA image from a soybean field.
}

\verb{*.tif} format

The following \code{.tif} files are provided as sample data, representing a slice
from a large orthomosaic with soybean plots in the vegetative stage. These
files were kindly provided by Arthur Bernardeli.
\itemize{
\item \strong{\code{ortho.tif}}: An orthomosaic with soybean plots (5 rows and 3 columns).
\item \strong{\code{dsm.tif}}: A digital surface model (DSM) for the soybean plots.
\item \strong{\code{dtm.tif}}: A digital terrain model (DTM) for the area.
\item \strong{\code{mask.tif}}: A mask that represents the soybean plants.
}
}
\source{
Personal data, Gupta et al. (2020).
}
\description{
Sample images installed with the \pkg{pliman} package
}
\references{
Gupta, S., Rosenthal, D. M., Stinchcombe, J. R., & Baucom, R. S.
(2020). The remarkable morphological diversity of leaf shape in sweet
potato (Ipomoea batatas): the influence of genetics, environment, and G×E.
New Phytologist, 225(5), 2183–2195. \doi{10.1111/NPH.16286}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
\keyword{images}
