% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{plot_msel}
\alias{plot_msel}
\title{Plot model misclassification}
\usage{
plot_msel(object, color = TRUE)
}
\arguments{
\item{object}{a list created by the \code{\link[=error_modelSel]{error_modelSel()}} function, containing
the results of a leave-one-out cross validation for model selection.}

\item{color}{logical, if TRUE (default) then a colour version of the barplot
will be produced, if FALSE then a grey scale version will be produced.}
}
\value{
a barplot of the proportion of simulations classified to any of the
models. In other words, a barplot of the confusion matrix.
}
\description{
Displays a barplot of the confusion matrix obtained with a leave-one-out
cross validation for model selection.
}
\details{
The barplot shows the proportion of validation simulations classified to each
of the models. This function can produce either a colour or a grey scale
barplot. If the classification of models is perfect, meaning that the model
probability of each model is one for the correct model, then each bar will
have a single colour representing its corresponding model.
}
\examples{
# load the matrix with simulated parameter values
data(sumstats)

# select a random simulation to act as target just to test the function
target <- sumstats[10 ,]

# create a "fake" vector of model indices
# this assumes that half the simulations were from one model and the other half from other model
# this is not true but serves as an example of how to use this function
index <- c(rep("model1", nrow(sumstats)/2), rep("model2", nrow(sumstats)/2))

# perform a leave-one-out cross validation of model selection
mysim <- sim_modelSel(index = index, sumstats = sumstats, nval = 10, tol = 0.1)

# compute the confusion matrix and the mean misclassification probabilities
myerror <- error_modelSel(object = mysim, print = FALSE)

# barplot of model misclassification
plot_msel(object = myerror)

}
