% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op.arima.R
\name{op.arima}
\alias{op.arima}
\title{op.arima}
\usage{
op.arima(
  arima_process = c(p = 1, d = 1, q = 1, P = 1, D = 1, Q = 1),
  seasonal_periodicity,
  time_serie,
  reg = NULL,
  horiz = 12,
  prop = 0.8,
  training_weight = 0.2,
  testing_weight = 0.8,
  parallelize = FALSE,
  clusters = detectCores(logical = FALSE),
  LAMBDA = NULL,
  ISP = 100,
  ...
)
}
\arguments{
\item{arima_process}{numeric. The ARIMA(p,d,q)(P,D,Q) process.}

\item{seasonal_periodicity}{numeric. The seasonal periodicity, 12 for monthly data.}

\item{time_serie}{ts. The univariate time series object to estimate the models.}

\item{reg}{Optionally, a vector or matrix of external regressors, which must have the same number of rows as time_serie.}

\item{horiz}{numeric. The forecast horizon.}

\item{prop}{numeric. Data proportion for training dataset.}

\item{training_weight}{numeric. Importance weight for the goodness of fit and precision measures in the training dataset.}

\item{testing_weight}{numeric. Importance weight for the goodness of fit and precision measures in the testing dataset.}

\item{parallelize}{logical. If TRUE, then use parallel processing.}

\item{clusters}{numeric. The number of clusters for the parallel process.}

\item{LAMBDA}{Optionally. See \code{\link[forecast:Arima]{forecast::Arima()}} for details.}

\item{ISP}{numeric. Overparameterization indicator to filter the estimated models in the (0,100] interval.}

\item{...}{additional arguments to be passed to \code{\link[forecast:Arima]{forecast::Arima()}}.}
}
\value{
\code{op.arima} returns an object of class \code{list} with the following components:

\item{arima_models}{all models defined by the \code{arima_process} argument.}
\item{final_measures}{goodness of fit and precision measures for each model.}
\item{bests}{a sorted list with the best ARIMA models.}
\item{best_model}{a list of "Arima", see \code{\link[forecast:Arima]{forecast::Arima()}}}
}
\description{
Estimates the best predictive ARIMA model using overparameterization.
}
\examples{

\donttest{

op.arima(arima_process = c(2,1,2,2,1,2),
time_serie = AirPassengers,
seasonal_periodicity = 12, parallelize=FALSE)

}

}
\references{
\insertRef{tesis}{popstudy}
}
\author{
Cesar Gamboa-Sanabria
}
