% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/dist_data_cdf_methods.R
\docType{methods}
\name{dist_all_cdf}
\alias{dist_all_cdf}
\alias{dist_data_all_cdf}
\alias{dist_data_all_cdf,discrete_distribution-method}
\alias{dist_data_cdf}
\alias{dist_data_cdf,ctn_distribution-method}
\alias{dist_data_cdf,discrete_distribution-method}
\title{The data cumulative distribution function}
\usage{
dist_all_cdf(m, lower_tail = TRUE, xmax = 1e+05)

dist_data_cdf(m, lower_tail = TRUE, xmax = 1e+05)

dist_data_all_cdf(m, lower_tail = TRUE, xmax = 1e+05)

\S4method{dist_data_cdf}{discrete_distribution}(m, lower_tail = TRUE,
  xmax = 1e+05)

\S4method{dist_data_all_cdf}{discrete_distribution}(m, lower_tail = TRUE,
  xmax = 1e+05)

\S4method{dist_data_cdf}{ctn_distribution}(m, lower_tail = TRUE,
  xmax = 1e+05)
}
\arguments{
\item{m}{a distribution object.}

\item{lower_tail}{logical; if \code{TRUE} (default), 
probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{xmax}{default \code{1e5}. The maximum x value calculated when working out the CDF.}
}
\description{
This is generic function for distribution objects.
This function calculates the data or empirical cdf.

The functions \code{dist_data_all_cdf} and \code{dist_all_cdf} are only available for discrete distributions.
Their main purpose is to optimise the bootstrap procedure, where generating a vector \code{xmin:xmax} is
very quick. Also, when bootstrapping very large values can be generated.
}
\note{
This method does *not* alter the internal state of
the distribution objects.
}
\examples{
##########################################
#Load data and create distribution object#
##########################################
data(moby_sample)
m = displ$new(moby_sample)
m$setXmin(7);m$setPars(2)

##########################################
# The data cdf                           #
##########################################
dist_data_cdf(m)
}

