% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{ragn}
\alias{ragn}
\title{Random Values from the Asymmetric Generalised Normal Distribution}
\usage{
ragn(n, location = 0, scale = 1, alpha = 0.5, beta = 2)
}
\arguments{
\item{n}{number of instances}

\item{location}{central location of the distribution}

\item{scale}{scale of the distribution. Must be strictly positive: \code{scale > 0.0}}

\item{alpha}{value between 0.0 and 1.0 that determines the skewness of the
distribution. \code{alpha > 0.5} creates a distribution with a negative skew
(left-skewed), i.e. the left tail of the distribution is elongated, and the
bulk of the distribution is located to the right. \code{alpha < 0.5} creates a
distribution with a positive skew (right-skewed), i.e. the right tail of
the distribution is elongated, and the bulk of the distribution is located
to the left. For \code{alpha = 0.0}, the distribution does not have a skew.}

\item{beta}{Strictly positive value (\code{beta > 0.0}) that determines the
overall shape of the generalised normal distribution. For \code{beta = 1}, an
asymmetric Laplace distribution is used. \code{beta = 2} draws values according
to an asymmetric normal distribution. For large \code{beta} the distribution
will approximate the uniform distribution.}
}
\value{
One or more numeric values drawn from the asymmetric generalised
normal distribution.
}
\description{
Draws random values from an asymmetric generalised normal distribution.
}
\details{
Random values drawn according to an asymmetric generalised normal
distribution. Here the asymmetric generalised normal distribution is a
symmetric general normal distribution, that is made asymmetric using the
procedure described by Gijbels et al. To generate random values we use the
quantile function of the symmetric generalised normal distribution that was
derived by M. Griffin.

The default parameter values produce values as if drawn from the standard
normal distribution with \eqn{\sigma = \sqrt{2}}, that is, the standard
deviation is not \eqn{\sqrt{2}} instead of \eqn{1}.
}
\examples{
# Draw values from a standard normal distribution.
x <- power.transform::ragn(n = 10000, scale = 1/sqrt(2))
hist(x, 50)

# Draw values from a left-skewed normal distribution.
x <- power.transform::ragn(n = 10000, scale = 1/sqrt(2), alpha = 0.8)
hist(x, 50)

# Draw values from a right-skewed normal distribution.
x <- power.transform::ragn(n = 10000, scale = 1/sqrt(2), alpha = 0.2)
hist(x, 50)

# Draw values from a standard laplace distribution.
x <- power.transform::ragn(n = 10000, scale = 1/sqrt(2), beta = 1.0)
hist(x, 50)
}
\references{
\enumerate{
\item Gijbels I, Karim R, Verhasselt A. Quantile Estimation in a Generalized
\item Griffin M (2018). gnorm: Generalized Normal/Exponential Power Distribution.
}
}
