% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power4test.R
\name{power4test}
\alias{power4test}
\alias{print.power4test}
\title{Estimate the Power of a Test}
\usage{
power4test(
  object = NULL,
  nrep = NULL,
  ptable = NULL,
  model = NULL,
  pop_es = NULL,
  standardized = TRUE,
  n = NULL,
  number_of_indicators = NULL,
  reliability = NULL,
  x_fun = list(),
  e_fun = list(),
  process_data = NULL,
  fit_model_args = list(),
  R = NULL,
  ci_type = "mc",
  gen_mc_args = list(),
  gen_boot_args = list(),
  test_fun = NULL,
  test_args = list(),
  map_names = c(fit = "fit"),
  results_fun = NULL,
  results_args = list(),
  test_name = NULL,
  test_note = NULL,
  do_the_test = TRUE,
  sim_all = NULL,
  iseed = NULL,
  parallel = FALSE,
  progress = TRUE,
  ncores = max(1, parallel::detectCores(logical = FALSE) - 1),
  es1 = c(n = 0, nil = 0, s = 0.1, m = 0.3, l = 0.5, si = 0.141, mi = 0.361, li = 0.51),
  es2 = c(n = 0, nil = 0, s = 0.05, m = 0.1, l = 0.15),
  es_ind = c("si", "mi", "li"),
  n_std = 1e+05,
  std_force_monte_carlo = FALSE
)

\method{print}{power4test}(
  x,
  what = c("data", "test"),
  digits = 3,
  digits_descriptive = 2,
  data_long = FALSE,
  test_long = FALSE,
  fit_to_all_args = list(),
  ...
)
}
\arguments{
\item{object}{Optional. If set to a
\code{power4test} object, it will be
updated using the value(s) in \code{n},
\code{pop_es}, and/or \code{nrep} if they changed,
or a new test will be conducted and
added to \code{objet}. See the help page
for details. Default is \code{NULL}.}

\item{nrep}{The number of replications
to generate the simulated datasets.
Default is \code{NULL}. Must be set when
called to create a \code{power4test}
object.}

\item{ptable}{The output of
\code{\link[=ptable_pop]{ptable_pop()}}, which is a
\code{ptable_pop} object, representing the
population model. If \code{NULL}, the
default, \code{\link[=ptable_pop]{ptable_pop()}} will be
called to generate the \code{ptable_pop}
object using \code{model} and \code{pop_es}.}

\item{model}{The \code{lavaan} model
syntax of the population model,
to be used by \code{\link[=ptable_pop]{ptable_pop()}}.
See 'Details' of
on how to specify the model.
Ignored if \code{ptable} is
specified.}

\item{pop_es}{The character vector or
multiline string to
specify population effect sizes
(population values of parameters). See
the help page on how to specify this
argument.
Ignored if \code{ptable} is
specified.}

\item{standardized}{Logical. If
\code{TRUE}, the default, variances and
error variances are scaled to ensure
the population variances of the
endogenous variables are close to
one, and hence the effect sizes
(population values) are
standardized effect sizes if the
variances of the continuous exogenous
variables are also equal to one.}

\item{n}{The sample size for each
dataset. Default is 100.}

\item{number_of_indicators}{A named
vector to specify the number of
indicators for each factors. See
the help page on how to set this
argument. Default is \code{NULL} and all
variables in the model syntax are
observed variables.
See the help page on how
to use this argument.}

\item{reliability}{A named vector
(for a single-group model) or a
named list of named vectors
(for a multigroup model)
to set the reliability coefficient
of each set of indicators. Default
is \code{NULL}.
See the help page on how
to use this argument.}

\item{x_fun}{The function(s) used to
generate the exogenous variables or
error terms. If
not supplied, or set to \code{list()}, the
default, the variables are generated
from a multivariate normal
distribution. See the help page on how
to use this argument.}

\item{e_fun}{The function(s) used to
generate the error terms of indicators,
if any. If
not supplied, or set to \code{list()}, the
default, the error terms of indicators
are generated
from a multivariate normal
distribution. Specify in the same
way as \code{x_fun}. Refer to the help
page on \code{x_fun} on how to use this
argument.}

\item{process_data}{If not \code{NULL}, it
must be a named list with these
elements: \code{fun} (required), the function
to further processing the simulated
data, such as generating missing data using
functions such as \code{\link[mice:ampute]{mice::ampute()}}; \code{args} (optional), a
named list of arguments to be passed
to \code{fun}, except the one for the
source data; \code{sim_data_name} (required) the
name of the argument to receive the
simulated data (e.g., \code{data} for
\code{\link[mice:ampute]{mice::ampute()}}); \code{processed_data_name}
(optional), the name of the data frame
after being processed by \code{fun},
such as the data frame
with missing data in the output of
\code{fun} (e.g., \code{"amp"} for \code{\link[mice:ampute]{mice::ampute()}}),
if omitted, the output of \code{fun} should
be the data frame with missing data.}

\item{fit_model_args}{A list of the
arguments to be passed to \code{\link[=fit_model]{fit_model()}}
when fitting the
model.
Should be a named list
with names being the names of the
arguments.}

\item{R}{The number of replications
to generate the Monte Carlo or
bootstrapping estimates
for each fit output. No Monte Carlo
nor bootstrapping
estimates will be generated if \code{R}
is set to \code{NULL}.}

\item{ci_type}{The type of
simulation-based confidence
intervals to use. Can be either
\code{"mc"} for Monte Carlo method
(the default) or \code{"boot"} for
nonparametric bootstrapping method.
Relevant for test functions that
make use of estimates generate by
\code{\link[=gen_boot]{gen_boot()}} or \code{\link[=gen_mc]{gen_mc()}}, such as
\code{\link[=test_indirect_effect]{test_indirect_effect()}}.}

\item{gen_mc_args}{A list of
arguments to be passed to
\code{\link[manymome:do_mc]{manymome::do_mc()}} when generating
the Monte Carlo estimates.
Should be a named argument
with names being the names of the
arguments. Used only if
\code{ci_type} is \verb{"mc".}}

\item{gen_boot_args}{A list of
arguments to be passed to
\code{\link[manymome:do_boot]{manymome::do_boot()}} when generating
the bootstrap estimates.
Should be a named argument
with names being the names of the
arguments. Used only if
\code{ci_type} is `"boot".}

\item{test_fun}{A function to do the
test. See 'Details' for the requirement
of this function. There are some
built-in test functions in \code{power4mome},
described in 'Details'.}

\item{test_args}{A list of arguments
to be passed to the \code{test_fun}
function. Default is \code{list()}.}

\item{map_names}{A named character
vector specifying how the content of
the element \code{extra} in
each replication of \code{sim_all} map
to the argument of \code{test_fun}.
Default is \code{c(fit = "fit")},
indicating that the element \code{fit}
in the element \code{extra} is set to
the argument \code{fit} of \code{test_fun}.
That is, for the first replication,
\code{fit = sim_out[[1]]$extra$fit} when
calling \code{test_fun}.}

\item{results_fun}{The function to be
used to extract the test results.
See \code{Details} for the requirements
of this function. Default is \code{NULL},
assuming that the output of
\code{test_fun} can be used directly.}

\item{results_args}{A list of
arguments to be passed to the
\code{results_fun} function. Default is
\code{list()}.}

\item{test_name}{String. The name
of the test. Default is \code{NULL},
and the name will be created from
\code{test_fun}. Note that if \code{sim_out}
is a \code{power4test} object and already
has a test of this name stored, it
will be replaced by the new results.}

\item{test_note}{String. An optional
note for the test, stored in the
attribute \code{test_note} of the output
of \code{\link[=do_test]{do_test()}}. Default is \code{NULL}.}

\item{do_the_test}{If \code{TRUE},
\code{\link[=do_test]{do_test()}} will be called to do the
test specified by \code{test_fun} on the
fit output of each dataset.}

\item{sim_all}{If set to either a
\code{sim_out} object (the output of
\code{\link[=sim_out]{sim_out()}} or a \code{power4test} object
(the output of \code{\link[=power4test]{power4test()}}), the
stored datasets and fit outputs will
be used for doing the test. Setting
\code{object} to the output of \code{\link[=power4test]{power4test()}}
is now the preferred method, but this
argument is kept for backward
compatibility.}

\item{iseed}{The seed for the random
number generator. Default is \code{NULL}
and the seed is not changed. This
seed will be set only once, when
calling \code{\link[=sim_data]{sim_data()}}.}

\item{parallel}{If \code{TRUE}, parallel
processing will be used when calling
other functions, if appropriate.
Default is \code{FALSE}.}

\item{progress}{If \code{TRUE}, the progress
of each step will be displayed.
Default is \code{TRUE}.}

\item{ncores}{The number of CPU
cores to use if parallel processing
is used.}

\item{es1}{Set the
values for each label of the effect
size (population value) for correlations and regression
paths.
Used only if \code{pop_es} is a named
vector or a multiline string.
See the help page on how to specify
this argument.}

\item{es2}{Set the
values for each label of the effect
size (population value) for product term.
Used only if \code{pop_es} is a named
vector or a multiline string.
See the help page on how to specify
this argument.}

\item{es_ind}{The names of labels
denoting the effect size of an
indirect effect. They will be
used to determine the population
values of the component paths along
an indirect path.}

\item{n_std}{The sample size used to
determine the error variances by
simulation when \code{std_force_monte_carlo}
is \code{TRUE}.}

\item{std_force_monte_carlo}{Logical.
If \code{FALSE}, the default,
standardization is done analytically
if the model has no product terms,
and by simulation if the model has
product terms. That is, error variances
required to ensure implied variances equal
to one are determined by simulation.
If \code{TRUE}, simulation
will be used whether the model has
product terms or not. Always fall
back to simulation if
analytical standardization failed.}

\item{x}{The object
to be printed.}

\item{what}{A string vector of
what to print, \code{"data"} for
simulated data and \code{"test"} for
stored test(s). Default is
\code{c("data", "test")}.}

\item{digits}{The numbers of digits
displayed after the decimal.}

\item{digits_descriptive}{The
number of digits displayed after
the decimal for the descriptive
statistics table.}

\item{data_long}{If \code{TRUE}, detailed
results will be printed when printing
the simulated data.}

\item{test_long}{If \code{TRUE}, detailed
results will be printed when printing
test(s).}

\item{fit_to_all_args}{A named list
of arguments to be passed to
\code{\link[lavaan:sem]{lavaan::sem()}} when the model is
fitted to a sample combined from}

\item{...}{Optional arguments to
be passed to other print methods}
}
\value{
An object of the class \code{power4test},
which is a list with two elements:
\itemize{
\item \code{sim_all}: The output of \code{\link[=sim_out]{sim_out()}}.
\item \code{test_all}: A named list of the
output of \code{\link[=do_test]{do_test()}}. The names
are the values of \code{test_name}.
This list can have more than one
test because a call to
\code{\link[=power4test]{power4test()}} can add new tests
to a \code{power4test} object.
}

The \code{print} method of \code{power4test}
returns \code{x} invisibly. Called for
its side effect.
}
\description{
An all-in-one function
that receives a model specification,
generates datasets, fits a model, does
the target test, and returns the test
results.
}
\details{
The function \code{\link[=power4test]{power4test()}} is an
all-in-one function for
estimating the power of a test for
a model, given the sample size
and effect sizes (population values
of model parameters).
}
\section{Workflow}{
This is the workflow:
\itemize{
\item If \code{object} is an output
of the output
of a previous call to
\code{\link[=power4test]{power4test()}} with \code{do_the_test}
set to \code{FALSE} and so has only the
model and the simulated data,
the following steps
will be skipped and go directly to
doing the test.
\itemize{
\item Call \code{\link[=sim_data]{sim_data()}} to determine
the population model and
generate the datasets, using
arguments such as \code{model} and
\code{pop_es}.
\item Call \code{\link[=fit_model]{fit_model()}} to fit a
model to each of the datasets,
which is the population model
by default.
\item If \code{R} is not \code{NULL} and
\code{ci_type = "mc"}, call
\code{\link[=gen_mc]{gen_mc()}} to generate Monte
Carlo estimates using
\code{\link[manymome:do_mc]{manymome::do_mc()}}. The estimates
can be used by supported functions
such as \code{\link[=test_indirect_effect]{test_indirect_effect()}}.
\item If \code{R} is not \code{NULL} and
\code{ci_type = "boot"}, call
\code{\link[=gen_boot]{gen_boot()}} to generate
bootstrap estimates using
\code{\link[manymome:do_boot]{manymome::do_boot()}}. The estimates
can be used by supported functions
such as \code{\link[=test_indirect_effect]{test_indirect_effect()}}.
\item Merge the results into a
\code{sim_out} object by calling
\code{\link[=sim_out]{sim_out()}}.
\item If \code{do_the_test} is \code{FALSE},
skip the remaining steps and
return a \code{power4test} object,
which contains only the data
generated and optionally the
Monte Carlo or bootstrap
estimates.
}
\item If \code{do_the_test} is \code{TRUE}, do
the test.
\itemize{
\item \code{\link[=do_test]{do_test()}} will be called to do
the test in the fit output of
each dataset.
}
\item Return a \code{power4test} object which
include the output of \code{sim_out}
and, if \code{do_the_test} is \code{TRUE},
the output of \code{\link[=do_test]{do_test()}}.
}

This function is to be used when
users are interested only in the
power of one or several tests on a
particular aspect of the model, such
as a parameter, given a specific
effect sizes and sample sizes.

Detailed description on major
arguments can be found in sections
below.

NOTE: The technical internal workflow of
of \code{\link[=power4test]{power4test()}} can be found in
this page: \url{https://sfcheung.github.io/power4mome/articles/power4test_workflow.html}.
}

\section{Updating a Condition}{
The function \code{\link[=power4test]{power4test()}} can also be used to
update a condition when only some
selected aspects is to be changed.

For example,
instead of calling this function with
all the arguments set just to change
the sample size, it can be called
by supplying an existing
\code{power4test} object and set only
\code{n} to a new sample size. The data
and the tests will be updated
automatically. See the examples for
an illustration.
}

\section{Adding Another Test}{
The function \code{\link[=power4test]{power4test()}} can also be used to
add a test to the output from a
previous call to \code{\link[=power4test]{power4test()}}.

For example, after simulating the
datasets and doing one test,
the output can be set to \code{object}
of \code{\link[=power4test]{power4test()}}, and set only
\code{test_fun} and, optionally,
\code{test_fun_args} to do one more test
on the generated datasets. The output
will be the original
object with the results of the new
test added. See the examples for
an illustration.
}

\section{Model Fitting Arguments ('fit_model_args')}{
For power analysis, usually, the
population model (\code{model}) is to be
fitted, and there is no need to
set \code{fit_model_args}.

If power analysis is to be conducted
for fitting a model that is not the
population model, of if non-default
settings are desired when fitting
a model, then the argument \code{fit_model_args}
needed to be set to customize the
call to \code{\link[=fit_model]{fit_model()}}.

For example,
users may want to examine the power
of a test when a misspecified model
is fitted, or the power of a test
when MLR is used as the estimator
when calling \code{\link[lavaan:sem]{lavaan::sem()}}.

See the help page of \code{\link[=fit_model]{fit_model()}}
for some examples.
}

\section{Specify the Population Model by 'model'}{
\subsection{Single-Group Model}{

For a single-group model, \code{model}
should be a \code{lavaan} model syntax
string of the \emph{form} of the model.
The population values of the model
parameters are to be determined by
\code{pop_es}.

If the model has latent factors,
the syntax in \code{model} should specify
only the \emph{structural model} for the
\emph{latent factors}. There is no
need to specify the measurement
part. Other functions will generate
the measurement part on top of this
model.

For example, this is a simple mediation
model:

\preformatted{"m ~ x
 y ~ m + x"}

Whether \code{m}, \code{x}, and \code{y} denote
observed variables or latent factors
are determined by other functions,
such as \code{\link[=power4test]{power4test()}}.
}

\subsection{Multigroup Model}{

Because the model is the population
model, equality constraints are
irrelevant and the model syntax
specifies only the \emph{form} of the
model. Therefore, \code{model} is
specified as in the case of single
group models.
}
}

\section{Specify 'pop_es' Using Named Vectors}{
The argument \code{pop_es} is for specifying
the population values of model
parameters. This section describes
how to do this using named vectors.
\subsection{Single-Group Model}{

If \code{pop_es} is specified by a named
vector, it must follow the convention
below.
\itemize{
\item The names of the vectors are
\code{lavaan} names for the selected
parameters. For example, \code{m ~ x}
denotes the path from \code{x} to \code{m}.
\item Alternatively, the names can be
either \code{".beta."} or \code{".cov."}.
Use \code{".beta."} to set the default
values for all regression coefficients.
Use \code{".cov."} to set the default
values for all correlations of
exogenous variables (e.g., predictors).
\item The names can also be of this form:
\code{".ind.(<path>)"}, whether \verb{<path>}
denote path in the model. For
example, \code{".ind.(x->m->y)"} denotes
the path from \code{x} through \code{m} to
\code{y}. Alternatively, the \code{lavaan}
symbol \code{~} can also be used:
\code{".ind.(y~m~x)"}. This form is used
to set the indirect effect (standardized,
by default) along this path. The
value for this name will override
other settings.
\item If using \code{lavaan} names, can
specify more than one parameter
using \code{+}. For example, \code{y ~ m + x}
denotes the two paths from \code{m} and
\code{x} to \code{y}.
\item The value of each element can be
the label for the effect size: \code{n}
for nil, \code{s} for small, \code{m} for
medium, and \code{l} for large. The
value for each label is determined
by \code{es1} and \code{es2}. See the section
on specifying these two arguments.
\item The value of \code{pop_es} can also be
set to a value, but it must be
quoted as a string, such as \code{"y ~ x" = ".31"}.
}

This is an example:

\preformatted{c(".beta." = "s",
  "m1 ~ x" = "-m",
  "m2 ~ m1" = "l",
  "y ~ x:w" = "s")}

In this example,
\itemize{
\item All regression coefficients are
set to small (\code{s}) by default, unless
specified otherwise.
\item The path from \code{x} to \code{m1} is
set to medium and negative (\code{-m}).
\item The path from \code{m1} to \code{m2} is set
to large (\code{l}).
\item The coefficient of the product
term \code{x:w} when predicting \code{y} is
set to small (\code{s}).
}
\subsection{Indirect Effect}{

When setting an indirect effect to
a symbol (default: \code{"si"}, \code{"mi"},
\code{"li"}, with \code{"i"} added to differentiate
them from the labels for a direct path),
the corresponding value is used to
determine the population values of
\emph{all} component paths along the pathway.
All the values are assumed to be equal.
Therefore, \code{".ind.(x->m->y)" = ".20"}
is equivalent to setting \code{m ~ x}
and \code{y ~ m} to the square root of
.20, such that the corresponding
indirect effect is equal to the
designated value.

This behavior, though restricted,
is for quick manipulation of the
indirect effect. If different values
along a pathway, set the value for
each path directly.

Only nonnegative value is supported.
Therefore, \code{".ind.(x->m->y)" = "-si"}
and \code{".ind.(x->m->y)" = "-.20"} will
throw an error.
}

}

\subsection{Multigroup Model}{

The argument \code{pop_es} also supports multigroup
models.

For \code{pop_es}, instead of
named vectors, named \emph{list} of
named vectors should be used.
\itemize{
\item The names are the parameters, or
keywords such as \code{.beta.} and
\code{.cov.}, like specifying the
population values for a single
group model.
\item The elements are character vectors.
If it has only one element (e.g.,
a single string), then it is the
the population value for all groups.
If it has more than one element
(e.g., a vector of three strings),
then they are the population values
of the groups. For a model of \emph{k}
groups, each vector must have
either \emph{k} elements or one element.
}

This is an example:

\preformatted{list("m ~ x" = "m",
     "y ~ m" = c("s", "m", "l"))}

In this model, the population value
of the path \code{m ~ x} is medium (\code{m}) for
all groups, while the population
values for the path \code{y ~ m} are
small (\code{s}), medium (\code{m}), and large (\code{l}),
respectively.
}
}

\section{Specify 'pop_es' Using a Multiline String}{
When setting the argument \code{pop_es},
instead of using a named vector
or named list for
\code{pop_es}, the population values of
model parameters can also be
specified using a multiline string,
as illustrated below, to be parsed
by \code{\link[=pop_es_yaml]{pop_es_yaml()}}.
\subsection{Single-Group Model}{

This is an example of the multiline string
for a single-group model:

\preformatted{y ~ m: l
m ~ x: m
y ~ x: nil}

The string must follow this format:
\itemize{
\item Each line starts with \verb{tag:}.
\itemize{
\item \code{tag} can be the name of a
parameter, in \code{lavaan} model
syntax format.
\itemize{
\item For example, \code{m ~ x}
denotes the path from \code{x} to \code{m}.
}
\item A tag in \code{lavaan} model syntax can
specify more than one parameter
using \code{+}.
\itemize{
\item For example, \code{y ~ m + x}
denotes the two paths from \code{m} and
\code{x} to \code{y}.
}
\item Alternatively, the \code{tag} can be
either \code{.beta.} or \code{.cov.}.
\itemize{
\item Use \code{.beta.} to set the default
values for all regression coefficients.
\item Use \code{.cov.} to set the default
values for all correlations of
exogenous variables (e.g., predictors).
}
}
\item After each tag is the value of the
population value:

-\code{nil} for nil (zero),
\itemize{
\item \code{s} for small,
\item \code{m} for medium, and
\item \code{l} for large.
\item \code{si}, \code{mi}, and \code{li} for
small, medium, and large a
standardized indirect effect,
respectively.
}

Note: \code{n} \emph{cannot} be used in this mode.

The
value for each label is determined
by \code{es1} and \code{es2} as described
in \code{\link[=ptable_pop]{ptable_pop()}}.
\itemize{
\item The value can also be
set to a numeric value, such as
\code{.30} or \code{-.30}.
}
}

This is another example:

\preformatted{.beta.: s
y ~ m: l}

In this example, all regression
coefficients are \code{small}, while
the path from \code{m} to \code{y} is large.
}

\subsection{Multigroup Model}{

This is an example of the string
for a multigroup model:

\preformatted{y ~ m: l
m ~ x:
  - nil
  - s
y ~ x: nil}

The format is similar to that for
a single-group model. If a parameter
has the same value for all groups,
then the line can be specified
as in the case of a single-group
model: \code{tag: value}.

If a parameter has different
values across groups, then it must
be in this format:
\itemize{
\item A line starts with the tag, followed
by two or more lines. Each line
starts with a hyphen \code{-} and the
value for a group.
}

For example:

\preformatted{m ~ x:
  - nil
  - s}

This denotes that the model has
two groups. The values of the path
from \code{x} to \code{m} for the two
groups are 0 (\code{nil}) and
small (\code{s}), respectively.

Another equivalent way to specify
the values are using \verb{[]}, on
the same line of a tag.

For example:

\preformatted{m ~ x: [nil, s]}

The number of groups is inferred
from the number of values for
a parameter. Therefore, if a tag
has more than one value, each tag
must has the same number of value,
or only one value.

The tag \code{.beta.} and \code{.cov.} can
also be used for multigroup models.
}

\subsection{Which Approach To Use}{

Note that using named vectors or
named lists is more reliable. However,
using a multiline string is
more user-friendly. If this method
failed, please use named vectors or
named list instead.
}

\subsection{Technical Details}{

The multiline string is parsed by \code{\link[yaml:read_yaml]{yaml::read_yaml()}}.
Therefore, the format requirement
is actually that of YAML. Users
knowledgeable of YAML can use other
equivalent way to specify the string.
}
}

\section{Set the Values for Effect Size Labels ('es1' and 'es2')}{
The vector \code{es1} is for correlations,
regression coefficients, and
indirect effect, and the
vector \code{es2} is for for standardized
moderation effect, the coefficients
of a product term. These labels
are to be used in interpreting
the specification in \code{pop_es}.
}

\section{Set 'number_of_indicators' and 'reliability'}{
The arguments \code{number_of_indicators}
and \code{reliability} are used to
specify the number of indicators
(e.g., items) for each factor,
and the population reliability
coefficient of each factor,
if the variables in the model
syntax are latent variables.
\subsection{Single-Group Model}{

If a variable in the model is to be
replaced by indicators in the generated
data, set
\code{number_of_indicators} to a named
numeric vector. The names are the
variables of variables with
indicators, as appeared in the
\code{model} syntax. The value of each
name is the number of indicators.

The
argument \code{reliability} should then be
set a named numeric vector (or list,
see the section on multigroup models)
to specify the population reliability
coefficient ("omega") of each set of
indicators. The population standardized factor
loadings are then computed to ensure
that the population reliability
coefficient is of the target value.

These are examples for a single group
model:

\preformatted{number of indicator = c(m = 3, x = 4, y = 5)}

The numbers of indicators for \code{m},
\code{x}, and \code{y} are 3, 4, and 5,
respectively.

\preformatted{reliability = c(m = .90, x = .80, y = .70)}

The population reliability
coefficients of \code{m}, \code{x}, and \code{y} are
.90, .80, and .70, respectively.
}

\subsection{Multigroup Models}{

Multigroup models are supported.
The number of groups is inferred
from \code{pop_es} (see the help page
of \code{\link[=ptable_pop]{ptable_pop()}}), or directly
from \code{ptable}.

For a multigroup model, the number
of indicators for each variable
must be the same across groups.

However, the population reliability
coefficients can be different
across groups. For a multigroup model
of \emph{k} groups,
with one or more population reliability
coefficients differ across groups,
the argument \code{reliability} should be
set to a named list. The names are
the variables to which the population
reliability coefficients are to be
set. The element for each name is
either a single value for the common
reliability coefficient, or a
numeric vector of the reliability
coefficient of each group.

This is an example of \code{reliability}
for a model with 2 groups:

\preformatted{reliability = list(x = .80, m = c(.70, .80))}

The reliability coefficients of \code{x} are
.80 in all groups, while the
reliability coefficients of \code{m} are
.70 in one group and .80 in another.
}

\subsection{Equal Numbers of Indicators and/or Reliability Coefficients}{

If all variables in the model has
the same number of indicators,
\code{number_of_indicators} can be set
to one single value.

Similarly, if all sets of indicators
have the same population reliability
in all groups, \code{reliability} can also
be set to one single value.
}
}

\section{Specify The Distributions of Exogenous Variables Or Error Terms Using 'x_fun'}{
By default, variables and error
terms are generated
from a multivariate normal distribution.
If desired, users can supply the
function used to generate an exogenous
variable and error term by setting \code{x_fun} to
a named list.

The names of the list are the variables
for which a user function will be used
to generate the data.

Each element of the list must also
be a list. The first element of this
list, can be unnamed, is the
function to be used. If other arguments
need to be supplied, they should be
included as named elements of this list.

For example:

\preformatted{x_fun = list(x = list(power4mome::rexp_rs),
             w = list(power4mome::rbinary_rs,
                      p1 = .70)))}

The variables \code{x} and \code{w} will be
generated by user-supplied functions.

For \code{x}, the function is
\code{power4mome::rexp_rs}. No additional
argument when calling this function.

For \code{w}, the function is
\code{power4mome::rbinary_rx}. The argument
\code{p1 = .70} will be passed to this
function when generating the values
of \code{w}.

If a variable is an endogenous
variable (e.g., being predicted by
another variable in a model), then
\code{x_fun} is used to generate its
\emph{error term}. Its implied population
distribution may still be different
from that generate by \code{x_fun} because
the distribution also depends on the
distribution of other variables
predicting it.

These are requirements for the
user-functions:
\itemize{
\item They must return a numeric vector.
\item They mush has an argument \code{n} for
the number of values.
\item The \emph{population} mean and standard
deviation of the generated values
must be 0 and 1, respectively.
}

The package \code{power4mome} has
helper functions for generating
values from some common nonnormal
distributions and then scaling them
to have population mean and standard
deviation equal to 0 and 1 (by default), respectively.
These are some of them:
\itemize{
\item \code{\link[=rbinary_rs]{rbinary_rs()}}.
\item \code{\link[=rexp_rs]{rexp_rs()}}.
\item \code{\link[=rbeta_rs]{rbeta_rs()}}.
\item \code{\link[=rlnorm_rs]{rlnorm_rs()}}.
\item \code{\link[=rpgnorm_rs]{rpgnorm_rs()}}.
}

To use \code{x_fun}, the variables must
have zero covariances with other
variables in the population. It is
possible to generate nonnormal
multivariate data but we believe this
is rarely needed when estimating
power \emph{before} having the data.
}

\section{Major Test-Related Arguments}{
\subsection{The test function (test_fun)}{

The function set to \code{test_fun},
the \emph{test function}, usually
should work
on the output of \code{\link[lavaan:sem]{lavaan::sem()}},
\code{\link[lmhelprs:many_lm]{lmhelprs::many_lm()}}, or
\code{\link[stats:lm]{stats::lm()}}, but can also be a
function that works on the output
of the function set to \code{fit_function}
when calling \code{\link[=fit_model]{fit_model()}} or
\code{\link[=power4test]{power4test()}} (see \code{fit_model_args}).

The function has two default
requirements.

First, it has an argument \code{fit}, to
be set to the output of
\code{\link[lavaan:sem]{lavaan::sem()}} or another output
stored in the element \code{extra$fit} of
a replication in the \code{sim_all}
object. (This requirement can be
relaxed; see the section on \code{map_names}.)

That is, the function definition
should be of this from: \code{FUN(fit, ...)}. This is the form of all
\verb{test_*} functions in \code{power4mome}.

If other arguments are to be passed
to the test function, they can be set
to \code{test_args} as a named list.

Second, the test function must
returns an output that (a) can be
processed by the results function
(see below), or (b) is of
the required format for the output of
a results function (see the next
section). If it already returns
an output of the required format,
then there is no need to set the
results function.
}

\subsection{The results function (results_fun)}{

The test results will be extracted
from the output of \code{test_fun} by the
function set to \code{results_fun},
the \emph{results function}. If
the \code{test_fun} already returns an
output of the expected format
(see below), then set \code{results_fun}
to \code{NULL}, the default. The output
of \code{test_fun} will be used for
estimating power.

The function set to \code{results_fun}
must accept the output of \code{test_fun},
as the first argument, and return a
named list (which can be a data frame)
or a named vector with some
of the following
elements:
\itemize{
\item \code{est}: Optional. The estimate of a
parameter, if applicable.
\item \code{se}: Optional. The standard error
of the estimate, if applicable.
\item \code{cilo}: Optional. The lower limit of the
confidence interval, if applicable.
\item \code{cihi}: Optional. The upper limit of the
confidence interval, if applicable.
\item \code{sig}: Required. If \code{1}, the test is
significant. If \code{0}, the test is not
significant. If the test cannot be
done for any reason, it should be
\code{NA}.
}

The results can then be used to
estimate the power or Type I
error of the test.

For example, if
the null hypothesis is false, then
the proportion of significant, that
is, the mean of the values of \code{sig}
across replications, is the power.
}

\subsection{Built-in test functions}{

The package \code{power4mome} has some ready-to-use
test functions:
\itemize{
\item \code{\link[=test_indirect_effect]{test_indirect_effect()}}
\item \code{\link[=test_cond_indirect]{test_cond_indirect()}}
\item \code{\link[=test_cond_indirect_effects]{test_cond_indirect_effects()}}
\item \code{\link[=test_moderation]{test_moderation()}}
\item \code{\link[=test_index_of_mome]{test_index_of_mome()}}
\item \code{\link[=test_parameters]{test_parameters()}}
}

Please refer to their help pages
for examples.
}

\subsection{The argument map_names}{

This argument is for developers using
a test function that has a different
name for the argument of the fit
object (\code{"fit"}, the default).

If \code{test_fun} is set to a function
that works on an output of, say,
\code{\link[lavaan:sem]{lavaan::sem()}} but the argument name
for the output is not \code{fit}, the
mapping can be changed by
\code{map_names}.

For example,
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}
receives an output of \code{\link[lavaan:sem]{lavaan::sem()}}
and reports the test results of model
parameters. However, the argument
name for the \code{lavaan} output is
\code{object.} To instruct \code{\link[=do_test]{do_test()}} to
do the test correctly when setting
\code{test_fun} to
\code{lavaan::parameterEstimates}, add
\code{map_names = c(object = "fit")}. The
element \code{fit} in a replication will
then set to the argument \code{object} of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.
}
}

\examples{

# Specify the model

model_simple_med <-
"
m ~ x
y ~ m + x
"

# Specify the population values

model_simple_med_es <-
"
m ~ x: m
y ~ m: l
y ~ x: n
"

# Set nrep to a large number in real analysis, such as 400
# Set `parallel` to TRUE for faster, usually much faster, analysis
# Set `progress` to TRUE to display the progress of the analysis

out <- power4test(nrep = 10,
                  model = model_simple_med,
                  pop_es = model_simple_med_es,
                  n = 100,
                  test_fun = test_parameters,
                  test_args = list(pars = "m~x"),
                  iseed = 1234,
                  parallel = FALSE,
                  progress = TRUE)

print(out,
      test_long = TRUE)

# Change the sample size

out1 <- power4test(out,
                   n = 200,
                   iseed = 1234,
                   parallel = FALSE,
                   progress = TRUE)

print(out1,
      test_long = TRUE)

# Add one more test

out2 <- power4test(out,
                   test_fun = test_parameters,
                   test_args = list(pars = "y~x"),
                   parallel = FALSE,
                   progress = TRUE)

print(out2,
      test_long = TRUE)

}
