% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PQRFE_main.R
\name{plot_taus}
\alias{plot_taus}
\title{Plot multiple penalized quantile regression}
\usage{
plot_taus(
  Beta,
  tau = 1:9/10,
  D,
  col = 2,
  lwd = 1,
  lty = 2,
  pch = 16,
  cex.axis = 1,
  cex.lab = 1,
  main = "",
  shadow = "gray90"
)
}
\arguments{
\item{Beta}{Numeric array, with three dimmensions: 1) tau, 2) coef., lower bound, upper bound, 3) exploratory variables.}

\item{tau}{Numeric vector, identifies the percentiles.}

\item{D}{covariate's number.}

\item{col}{color.}

\item{lwd}{line width.}

\item{lty}{line type.}

\item{pch}{point character.}

\item{cex.axis}{cex axis length.}

\item{cex.lab}{cex axis length.}

\item{main}{title.}

\item{shadow}{color of the Confidence Interval 95\%}
}
\value{
None
}
\description{
plot penalized quantile regression for several taus
}
\examples{
n = 10
m = 5
d = 4
N = n*m
L = N*d
x = matrix(rnorm(L), ncol=d, nrow=N)
subj = rep(1:n, each=m)
alpha = rnorm(n)
beta = rnorm(d)
eps = rnorm(N)
y = as.vector(x \%*\% beta + rep(alpha, each=m) + eps)

Beta = mpqr(x,y,subj,tau=1:9/10, effect="lasso", c = Inf)
plot_taus(Beta,tau=1:9/10,D=1)

}
