% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_bin_pi.R
\name{beta_bin_pi}
\alias{beta_bin_pi}
\title{Prediction intervals for beta-binomial data}
\usage{
beta_bin_pi(
  histdat,
  newdat = NULL,
  newsize = NULL,
  alternative = "both",
  alpha = 0.05,
  nboot = 10000,
  delta_min = 0.01,
  delta_max = 10,
  tolerance = 0.001,
  traceplot = TRUE,
  n_bisec = 30
)
}
\arguments{
\item{histdat}{a \code{data.frame} with two columns (number of successes and
number of failures) containing the historical data}

\item{newdat}{a \code{data.frame} with two columns (number of successes and
number of failures) containing the future data}

\item{newsize}{a vector containing the future cluster sizes}

\item{alternative}{either "both", "upper" or "lower". \code{alternative}
specifies if a prediction interval or an upper or a lower prediction limit
should be computed}

\item{alpha}{defines the level of confidence (1-\code{alpha})}

\item{nboot}{number of bootstraps}

\item{delta_min}{lower start value for bisection}

\item{delta_max}{upper start value for bisection}

\item{tolerance}{tolerance for the coverage probability in the bisection}

\item{traceplot}{plot for visualization of the bisection process}

\item{n_bisec}{maximal number of bisection steps}
}
\value{
If \code{newdat} is specified: A \code{data.frame} that contains the future data,
 the historical proportion (hist_prob),
 the calibrated coefficient (quant_calib),
 the prediction standard error (pred_se),
 the prediction interval (lower and upper)
 and a statement if the prediction interval covers the future observation (cover).

 If \code{newsize} is specified: A \code{data.frame} that contains the future cluster sizes (total)
 the historical proportion (hist_prob),
 the calibrated coefficient (quant_calib),
 the prediction standard error (pred_se)
 and the prediction interval (lower and upper).

 If \code{alternative} is set to "lower": Lower prediction bounds are computed instead
 of a prediction interval.

 If \code{alternative} is set to "upper": Upper prediction bounds are computed instead
 of a prediction interval.

 If traceplot=TRUE, a graphical overview about the bisection process is given.
}
\description{
beta_bin_pi calculates bootstrap calibrated prediction intervals for
beta-binomial data
}
\details{
This function returns bootstrap calibrated prediction intervals
\deqn{[l,u]_m = \hat{y}_m \pm q \sqrt{\hat{var}(\hat{y}_m - y_m)}}
with \eqn{\hat{y}_m} as the predicted future number of successes for \eqn{m=1,...,M}
future clusters, \eqn{y_m} as the observed future number of successes,
\eqn{\sqrt{\hat{var}(\hat{y}_m - y_m)}} as the prediction standard error and \eqn{q}
as the bootstrap calibrated coefficient that approximates a quantile from a
multivariate normal distribution. \cr
Please note that the predicted future number of successes is based on the future
cluster size \eqn{n_m} and the success probability estimated from the historical
data \eqn{\pi^{hist}} such that \eqn{\hat{y}_m=\pi^{hist} n_m}. Hence, the
prediction intervals \eqn{[l,u]_m} are different for each of the \eqn{m} future clusters,
if their size is not the same.
}
\examples{
# Historical data
bb_dat1

# Future data
bb_dat2

# Prediction interval using bb_dat2 as future data
beta_bin_pi(histdat=bb_dat1, newdat=bb_dat2, nboot=100)

# Upper prediction bound for m=3 future numbers of success
# that are based on cluster sizes 40, 50, 60 respectively
beta_bin_pi(histdat=bb_dat1, newsize=c(40, 50, 60), alternative="upper", nboot=100)

# Please note that nboot was set to 100 in order to decrease computing time
# of the example. For a valid analysis set nboot=10000.


}
