% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcs_ptp.R
\name{calculate_dcs_1993_sig_cad_ptp}
\alias{calculate_dcs_1993_sig_cad_ptp}
\title{Calculate 1993 Duke Clinical Score for Significant CAD}
\usage{
calculate_dcs_1993_sig_cad_ptp(
  age,
  sex,
  chest_pain_type,
  have_mi,
  have_smoking_history,
  have_dyslipidemia,
  have_diabetes,
  have_q_waves,
  have_st_t_changes
)
}
\arguments{
\item{age}{Input integer value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{chest_pain_type}{Input characters (typical, atypical, nonanginal)
to indicate the chest pain characteristics of the patient.
\itemize{
  \item typical stands for the patient having typical chest pain.
  \item atypical stands for the patient having atypical chest pain.
  \item nonanginal stands for the patient having nonanginal or non-specific chest pain.
}}

\item{have_mi}{Input characters (no, yes) to indicate if the patient
has a previous history of Myocardial Infarction (MI).
\itemize{
  \item no stands for the patient not having a previous history of MI.
  \item yes stands for the patient a previous history of MI.
}}

\item{have_smoking_history}{Input characters (no, yes) to indicate if the patient
has a smoking history (current or past smoker).
\itemize{
  \item no stands for not having a smoking history (non-smoker).
  \item yes stands for having a smoking history (current or past smoker).
}}

\item{have_dyslipidemia}{Input characters (no, yes) to indicate if the patient
has dyslipidemia.
\itemize{
  \item no stands for not having dyslipidemia.
  \item yes stands for having dyslipidemia.
}}

\item{have_diabetes}{Input characters (no, yes) to indicate if the patient
has diabetes.
\itemize{
  \item no stands for not having diabetes.
  \item yes stands for having diabetes.
}}

\item{have_q_waves}{Input characters (no, yes) to indicate if the patient
has Q waves on electrocardiogram (ECG).
\itemize{
  \item no stands for the patient not having Q waves on ECG.
  \item yes stands for the patient having Q waves on ECG.
}}

\item{have_st_t_changes}{Input characters (no, yes) to indicate if the patient
has ST-T changes on electrocardiogram (ECG).
\itemize{
  \item no stands for the patient not having ST-T changes on ECG.
  \item yes stands for the patient having ST-T changes on ECG.
}}
}
\value{
A numeric value representing the patient's PTP for significant
(>75\% luminal diameter narrowing of at least one major coronary artery) CAD
based on the 1993 Duke Clinical Score.
}
\description{
This function returns a patient's
pre-test probability (PTP) of significant (>75\% luminal diameter narrowing
of at least one major coronary artery) coronary artery disease based on the
1993 Duke Clinical Score.
}
\details{
The predictive model is based on
patients referred for cardiac catheterisation between 1969 and 1983.
}
\examples{
# 40 year old female with typical chest pain,
# previous history of MI,
# has diabetes but no dyslipidemia and a non-smoker.
# She has Q waves but no ST-T changes on ECG.

calculate_dcs_1993_sig_cad_ptp(
    age = 40,
    sex = "female",
    chest_pain_type = "typical",
    have_mi = "yes",
    have_smoking_history = "no",
    have_dyslipidemia = "no",
    have_diabetes = "yes",
    have_q_waves = "yes",
    have_st_t_changes = "no"
)
}
