% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lined_chart.R, R/lined_chart_plotly_i.R
\name{lined_chart}
\alias{lined_chart}
\alias{lined_chart.eventlog}
\alias{lined_chart.activitylog}
\alias{lined_chart.grouped_eventlog}
\alias{lined_chart.grouped_activitylog}
\alias{ilined_chart}
\alias{iplotly_lined_chart}
\alias{plotly_lined_chart}
\title{Lined chart}
\usage{
lined_chart(
  log,
  x = c("absolute", "relative"),
  sort = NULL,
  color,
  units,
  line_width = 2,
  plotly,
  eventlog = deprecated(),
  ...
)

\method{lined_chart}{eventlog}(
  log,
  x = c("absolute", "relative"),
  sort = NULL,
  color = NULL,
  units = c("weeks", "days", "hours", "mins", "secs"),
  line_width = 2,
  plotly = FALSE,
  eventlog = deprecated(),
  ...
)

\method{lined_chart}{activitylog}(
  log,
  x = c("absolute", "relative"),
  sort = NULL,
  color = NULL,
  units = c("weeks", "days", "hours", "mins", "secs"),
  line_width = 2,
  plotly = FALSE,
  eventlog = deprecated(),
  ...
)

\method{lined_chart}{grouped_eventlog}(
  log,
  x = c("absolute", "relative"),
  sort = NULL,
  color = NULL,
  units = c("weeks", "days", "hours", "mins", "secs"),
  line_width = 2,
  plotly = FALSE,
  eventlog = deprecated(),
  ...
)

\method{lined_chart}{grouped_activitylog}(
  log,
  x = c("absolute", "relative"),
  sort = NULL,
  color = NULL,
  units = c("weeks", "days", "hours", "mins", "secs"),
  line_width = 2,
  plotly = FALSE,
  eventlog = deprecated(),
  ...
)

ilined_chart(eventlog, plotly = FALSE)

iplotly_lined_chart(eventlog)

plotly_lined_chart(eventlog, color = NULL, ...)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{x}{Value for plot on x-axis: absolute time or relative time (since start, since start of week, since start of day)}

\item{sort}{Ordering of the cases on y-axis: start, end or duration, start_week, start_day}

\item{color}{Optional. Should be a case attribute! No coloring applied by default.}

\item{units}{Time units to use on x-axis in case of relative time.}

\item{line_width}{The width of lines}

\item{plotly}{Return plotly object}

\item{eventlog}{Eventlog object}

\item{...}{Deprecated arguments}
}
\description{
Create a lined chart to view all cases at a glance
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Create lined chart for eventlog

\item \code{activitylog}: Create lined chart for activity log

\item \code{grouped_eventlog}: Create lined chart for grouped eventlog

\item \code{grouped_activitylog}: Create lined chart for grouped activitylog
}}

