% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights_internal.R
\name{.weights_calc}
\alias{.weights_calc}
\title{(Internal) Worker function for weight calculation}
\usage{
.weights_calc(specification, target, weightAlias, dichotomy, by, data)
}
\arguments{
\item{specification}{a \code{StudySpecification} object created by one of
\code{rct_spec()}, \code{rd_spec()}, or \code{obs_spec()}.}

\item{target}{One of "ate" or "ett"; \code{ate()} and \code{ett()} chooses
these automatically.}

\item{weightAlias}{An alias for the weight target, currently one of "ate",
"ett", "att". Chosen by \code{ate()} and \code{ett()} automatically.}

\item{dichotomy}{optional; a formula defining the dichotomy of the treatment
variable if it isn't already \code{0}/\code{1}. See details of help for
\code{ate()} or \code{ett()} e.g. for details.}

\item{by}{optional; named vector or list connecting names of unit of
assignment/ variables in \code{specification} to unit of
assignment/cluster variables in \code{data}. Names represent variables in
the StudySpecification; values represent variables in the data. Only
needed if variable names differ.}

\item{data}{optionally the data for the analysis to be performed on. May be
excluded if these functions are included as the \code{weights} argument of
a model.}
}
\value{
a \code{WeightedStudySpecification} object
}
\description{
Called from \code{ate()} or \code{ett()}.
}
\keyword{internal}
