% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_cut_from_merge_id}
\alias{get_cut_from_merge_id}
\title{Get clustering of leaves from merge_id}
\usage{
get_cut_from_merge_id(hc, merge_id)
}
\arguments{
\item{hc}{An object of class `hclust`}

\item{merge_id}{A numeric vector.  Indexing of nodes should match that of the
`merge` matrix in an `hclust` object.  In particular, positive numbers 
specify interior nodes and negative numbers specify leaves. These nodes must
define a partition of the leaves, meaning no node in `merge_id` should be a
descendant of another and every leaf should either be included directly or 
be the descendant of one of the interior nodes referenced by `merge_id`.}
}
\description{
This function expects a set of node id's of a hierarchical clustering object
that would define a partition of the leaves.  It returns a vector giving the 
implied clustering of the leaves (analogous to the output of `stats::cutree`).
}
