% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/make_model_string_model.R
\name{make_model_string_model}
\alias{make_model_string_model}
\alias{make_model_string_model,ANY,ANY,Analysis-method}
\alias{make_model_string_model,BorrowingFull,ANY,Analysis-method}
\alias{make_model_string_model,BorrowingNone,ANY,Analysis-method}
\alias{make_model_string_model,BorrowingHierarchicalCommensurate,ANY,Analysis-method}
\title{Create Stan Code for Model}
\usage{
make_model_string_model(borrowing, outcome, analysis_obj)

\S4method{make_model_string_model}{ANY,ANY,Analysis}(borrowing, outcome, analysis_obj)

\S4method{make_model_string_model}{BorrowingFull,ANY,Analysis}(borrowing, outcome, analysis_obj)

\S4method{make_model_string_model}{BorrowingNone,ANY,Analysis}(borrowing, outcome, analysis_obj)

\S4method{make_model_string_model}{BorrowingHierarchicalCommensurate,ANY,Analysis}(borrowing, outcome, analysis_obj)
}
\arguments{
\item{borrowing}{borrowing object}

\item{outcome}{outcome object}

\item{analysis_obj}{analysis object}
}
\value{
\code{glue} \code{character} containing the Stan code for the data block.
}
\description{
Create Stan Code for Model
}
\examples{
anls_obj <- create_analysis_obj(
    data_matrix = example_matrix,
    outcome = outcome_surv_exponential(
      "time",
      "cnsr",
      baseline_prior = prior_normal(0, 1000)
    ),
    borrowing = borrowing_hierarchical_commensurate(
      "ext",
      prior_exponential(.001)
    ),
    treatment = treatment_details(
      "trt",
      prior_normal(0, 1000)
    ),
    covariates = add_covariates(
      covariates = c("cov1", "cov2"),
      priors = prior_normal(0, 1000)
    )
  )
make_model_string_model(anls_obj@borrowing, anls_obj@outcome, anls_obj)
}
