% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windows.R
\name{GetSubsetOfWindowsTwoLevels}
\alias{GetSubsetOfWindowsTwoLevels}
\title{Select only windows (dataframes) where a two specified columns must match specified values}
\usage{
GetSubsetOfWindowsTwoLevels(
  list.of.windows,
  level1.column.name,
  level2.column.name,
  level1.categories,
  level2.categories
)
}
\arguments{
\item{list.of.windows}{A list of windows (dataframes) and each window can only have a single unique value for the two specified columns.}

\item{level1.column.name}{A String that specifies the column name to use for the first level. This column should only contain one unique value within each window.}

\item{level2.column.name}{A String that specifies the column name to use for the second level. This column should only contain one unique value within each window.}

\item{level1.categories}{A vector that specifies the possible labels in the level1 column.}

\item{level2.categories}{A vector that specifies the possible labels in the level2 column.}
}
\value{
List containing only selected windows
}
\description{
Looks at all the windows (dataframes) in a list of homogeneous windows. And
only selects the windows where the column values for two columns matches
the specified values.
}
\details{
Takes a List of windows (dataframes) where each window is a homogeneous window,
which means in each window, there is only one unique value in the specified
column. This function looks through the homogeneous windows in the List, selects
the windows that have specified column value(s) in the first specified column, then
from the windows selected based on the first column, windows are further selected
to have specified column value(s) in the second specified column. Puts these windows
into a new List and outputs the new List of windows. Uses the
GetSubsetOfWindows() function.
}
\examples{
#Example using a dataframe with 5 homogeneous windows.

#Windows are homogeneous if looking at col.two and col.three values.
window.name.column <- c(10, 10, 10, 20, 20, 20, 30, 30, 30, 30, 40, 40, 50, 50, 50, 50)
col.two <- c("a", "a", "a", "a", "a", "a", "a", "a", "a", "a", "b", "b", "a", "a", "a", "a")
col.three <- c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 3, 3, 3, 3)

multi.window.data <- data.frame(window.name.column, col.two, col.three)

list.of.homogeneous.windows <- GetHomogeneousWindows(multi.window.data,
"window.name.column", c("col.two", "col.three"))

result <- GetSubsetOfWindowsTwoLevels(list.of.homogeneous.windows, "col.two", "col.three",
c("a"), c("1", "2"))

#Should contain windows 10, 20, 30 because col.two is "a" and col.three can be "1" or "2"
result

}
