% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_rep_zero.R
\name{sig_rep_zero}
\alias{sig_rep_zero}
\title{Replace invalid fatty acid signature proportions}
\usage{
sig_rep_zero(sig_data, zero_rep = 75)
}
\arguments{
\item{sig_data}{A numeric matrix containing signature data as either
proportions or percentages in column-major format.}

\item{zero_rep}{A constant associated with the method and value to be
used to replace invalid values.  See Details. Default value 75.}
}
\value{
A list containing the following elements: \describe{
  \item{sig_adj}{The signature data with non-positive or missing proportions
                 replaced and scaled to sum to 1.0.}
  \item{rep_val}{The value used to replace invalid proporitons.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
  }
}
\description{
The utility function \code{sig_rep_zero} replaces fatty acid signature
proportions that are less than or equal to zero or missing with a small
constant and uses the multiplicative method (Martin-Fernandez et al. 2011)
to scale the proportions to sum to 1.
}
\section{Details}{

The function \code{sig_rep_zero} is an internal utility function.

The Kullback-Leibler (Iverson et al. 2004) and Aitchison (Stewart et al.
2014) distance measures are not defined for proportions of zero.
Consequently, if either of these distance measures will be used in an
analysis, the argument \code{zero_rep} should be strictly greater than 0.
The chi-square distance measure (Stewart et al. 2014) is defined for
proportions of zero, so if that distance measure will be used in the
analysis, the argument \code{zero_rep} may equal zero.  For simulation or
other comparative work involving multiple distance measures, it may be
advisable to use a common value to replace zeros.

The argument \code{zero_rep} must be either:\itemize{
  \item Greater than or equal to 0 and no greater than 0.01, in which case
    the specified value is used to replace invalid proportions.
  \item Between 10 and 100, with an uninformed  default of 75.  In this
    case, \code{zero_rep} is interpreted as a percentage.  The smallest
    non-zero proportion in \code{sig_data} is multiplied by the percentage
    and divided by 100.  The result is used to replace invalid proportions.
  }

Although Bromaghin et al. (2016) found that scaling signatures
by varying constants introduces a bias in diet estimation, the slight
distortion of the signatures caused by replacing invalid proportions
with a small constant that varies between signatures is unlikely to
introduce meaningful bias.
}

\section{References}{

Bromaghin, J.F., S.M. Budge, and G.W. Thiemann. 2016. Should fatty
  acid signature proportions sum to 1 for diet estimation?
  \emph{Ecological Research} 31:597-606.

Iverson, S.J., C. Field, W.D. Bowen, and W. Blanchard. 2004.
  Quantitative fatty acid signature analysis: A new method of
  estimating predator diets. \emph{Ecological Monographs} 74:211-235.

Martin-Fernandez, J.A., J. Palarea-Albaladejo, and R.A. Olea. 2011.
  Dealing with zeros. P. 43-58 in V. Pawlowsky-Glahn and A. Buccianto,
  eds. Compositional data analysis: theory and application. John Wiley,
  Chichester.

Stewart, C., and C. Field. 2011. Managing the essential zeros in quantitative
 fatty acid signature analysis. \emph{Journal of Agricultural, Biological, and
 Environmental Statistics} 16:45?69.
}

