% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_helpers.R
\name{setcolorder_by_pattern}
\alias{setcolorder_by_pattern}
\title{Order Columns by Variable Name Patterns}
\usage{
setcolorder_by_pattern(data_frame, pattern)
}
\arguments{
\item{data_frame}{The data frame to be ordered.}

\item{pattern}{The pattern which is used for ordering the data frame columns.}
}
\value{
Returns a reordered data frame with the ordered variables at the end.
}
\description{
Order variables in a data frame based on a pattern rather than whole variable
names. E.g. grab every variable that contains "sum" in it's name and order
them together so that they appear next to each other.
}
\examples{
# Example data frame
my_data <- dummy_data(1000)

# Summarise data
all_nested <- my_data |>
    summarise_plus(class      = c(year, sex),
                   values     = c(weight, income),
                   statistics = c("sum", "pct_group", "pct_total", "sum_wgt", "freq"),
                   weight     = weight,
                   nesting    = "deepest",
                   na.rm      = TRUE)

# Set a different column order
new_order <- all_nested |> setcolorder_by_pattern(c("pct", "freq", "sum"))

}
