% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docnames.R
\name{docnames}
\alias{docnames}
\alias{docnames<-}
\alias{docid}
\title{Get or set document names}
\usage{
docnames(x)

docnames(x) <- value

docid(x)
}
\arguments{
\item{x}{the object with docnames}

\item{value}{a character vector of the same length as \code{x}}
}
\value{
\code{docnames} returns a character vector of the document names

\verb{docnames <-} assigns new values to the document names of an object.
docnames can only be character, so any non-character value assigned to be a
docname will be coerced to mode \code{character}.

\code{docid} returns an internal variable denoting the original "docname"
from which a document came.  Unless an object has been reshaped (e.g.
\code{\link[=corpus_reshape]{corpus_reshape()}}, split (e.g.\code{\link[=tokens_split]{tokens_split()}}), or segmented (e.g.
\code{\link[=corpus_segment]{corpus_segment()}}), \code{docid(x)} will return the docnames.
}
\description{
Get or set the document names of a \link{corpus}, \link{tokens}, or \link{dfm} object.
}
\note{
\code{docid} is designed primarily for developers, not for end users.  In
most cases, you will want \code{docnames} instead.  It is, however, the
default for \link{groups}, so that documents that have been previously reshaped
(e.g. \code{\link[=corpus_reshape]{corpus_reshape()}}, split (e.g.\code{\link[=tokens_split]{tokens_split()}}), or segmented (e.g.
\code{\link[=corpus_segment]{corpus_segment()}}) will be regrouped into their original \code{docnames} when
\code{groups = docid(x)}.
}
\examples{
# get and set doument names to a corpus
corp <- data_corpus_inaugural
docnames(corp) <- char_tolower(docnames(corp))

# get and set doument names to a tokens
toks <- tokens(data_corpus_inaugural)
docnames(toks) <- char_tolower(docnames(toks))

# get and set doument names to a dfm
dfmat <- dfm(data_corpus_inaugural[1:5])
docnames(dfmat) <- char_tolower(docnames(dfmat))

# reassign the document names of the inaugural speech corpus
docnames(data_corpus_inaugural) <- paste("Speech", 1:ndoc(data_corpus_inaugural), sep="")

# docid
corp <- corpus(c(textone = "This is a sentence.  Another sentence.  Yet another.",
                 textwo = "Sentence 1. Sentence 2."))
corpsent <- corp \%>\%
    corpus_reshape(to = "sentences")
docnames(corpsent)
docid(corpsent)
docid(tokens(corpsent))
docid(dfm(tokens(corpsent)))
}
\seealso{
\code{\link[=featnames]{featnames()}}
}
\keyword{corpus}
\keyword{dfm}
