/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Interval;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.visitors.ExpressionCompactor;
import org.jpmml.rexp.ExpressionTranslatorConstants;
import org.jpmml.rexp.ExpressionTranslatorTokenManager;
import org.jpmml.rexp.FunctionExpression;
import org.jpmml.rexp.ParseException;
import org.jpmml.rexp.Provider;
import org.jpmml.rexp.SimpleCharStream;
import org.jpmml.rexp.StringProvider;
import org.jpmml.rexp.Token;
import org.jpmml.rexp.TokenMgrException;

public class ExpressionTranslator
implements ExpressionTranslatorConstants {
    public ExpressionTranslatorTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[27];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[7];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static Expression translateExpression(String string) {
        return ExpressionTranslator.translateExpression(string, true);
    }

    public static Expression translateExpression(String string, boolean compact) {
        Expression expression;
        try {
            ExpressionTranslator translator = new ExpressionTranslator(string);
            expression = translator.translateExpressionInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(string, pe);
        }
        if (compact) {
            ExpressionCompactor compactor = new ExpressionCompactor();
            compactor.applyTo((Visitable)expression);
        }
        return expression;
    }

    public static Interval translateInterval(String string) {
        Interval interval;
        try {
            ExpressionTranslator translator = new ExpressionTranslator(string);
            interval = translator.translateIntervalInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(string, pe);
        }
        return interval;
    }

    private static String translateLogicalOperator(Token operator) {
        switch (operator.kind) {
            case 14: {
                return "and";
            }
            case 15: {
                return "or";
            }
        }
        throw new IllegalArgumentException(operator.image);
    }

    private static String translateArithmeticOperator(Token operator) {
        switch (operator.kind) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return operator.image;
            }
            case 7: {
                return "x-modulo";
            }
        }
        throw new IllegalArgumentException(operator.image);
    }

    private static String translateRelationalOperator(Token operator) {
        switch (operator.kind) {
            case 17: {
                return "equal";
            }
            case 18: {
                return "notEqual";
            }
            case 19: {
                return "lessThan";
            }
            case 20: {
                return "lessOrEqual";
            }
            case 21: {
                return "greaterThan";
            }
            case 22: {
                return "greaterOrEqual";
            }
        }
        throw new IllegalArgumentException(operator.image);
    }

    private static String translateFunction(String function) {
        switch (function) {
            case "abs": {
                return "abs";
            }
            case "ceiling": {
                return "ceil";
            }
            case "exp": {
                return "exp";
            }
            case "floor": {
                return "floor";
            }
            case "log": {
                return "ln";
            }
            case "log10": {
                return "log10";
            }
            case "round": {
                return "round";
            }
            case "sqrt": {
                return "sqrt";
            }
        }
        switch (function) {
            case "is.na": {
                return "isMissing";
            }
        }
        throw new IllegalArgumentException(function);
    }

    private static String translateValue(Token value) {
        String image = value.image;
        switch (value.kind) {
            case 36: 
            case 45: {
                return image.toLowerCase();
            }
            case 37: {
                return "Infinity";
            }
            case 43: {
                return "NaN";
            }
            case 49: {
                return image.substring(1, image.length() - 1);
            }
        }
        return image;
    }

    private static String translateTag(Token tag) {
        String image = tag.image;
        switch (tag.kind) {
            case 48: {
                return image;
            }
            case 49: {
                return image.substring(1, image.length() - 1);
            }
        }
        throw new IllegalArgumentException();
    }

    private static Interval.Closure translateClosure(String leftBound, String rightBound) {
        String closure;
        switch (closure = leftBound + rightBound) {
            case "()": {
                return Interval.Closure.OPEN_OPEN;
            }
            case "(]": {
                return Interval.Closure.OPEN_CLOSED;
            }
            case "[)": {
                return Interval.Closure.CLOSED_OPEN;
            }
            case "[]": {
                return Interval.Closure.CLOSED_CLOSED;
            }
        }
        throw new IllegalArgumentException(closure);
    }

    private static Double filterMargin(Double value) {
        if (value.isNaN()) {
            throw new IllegalArgumentException();
        }
        if (value.isInfinite()) {
            return null;
        }
        return value;
    }

    private final Expression translateExpressionInternal() throws ParseException {
        Expression expression = this.Expression();
        this.jj_consume_token(0);
        return expression;
    }

    public final Expression Expression() throws ParseException {
        Expression expression;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            expression = this.IfExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: 
                case 4: 
                case 10: 
                case 16: 
                case 36: 
                case 37: 
                case 43: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    expression = this.OrExpression();
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expression;
    }

    public final Expression IfExpression() throws ParseException {
        Expression second = null;
        this.jj_consume_token(31);
        this.jj_consume_token(10);
        Expression condition = this.Expression();
        this.jj_consume_token(11);
        Expression first = this.Expression();
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(30);
            second = this.Expression();
        }
        if (second != null) {
            return PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{condition, first, second});
        }
        return PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{condition, first});
    }

    public final Expression OrExpression() throws ParseException {
        Expression left = this.AndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            Token operator = this.jj_consume_token(15);
            Expression right = this.AndExpression();
            left = PMMLUtil.createApply((String)ExpressionTranslator.translateLogicalOperator(operator), (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    public final Expression AndExpression() throws ParseException {
        Expression left = this.NegationExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            Token operator = this.jj_consume_token(14);
            Expression right = this.NegationExpression();
            left = PMMLUtil.createApply((String)ExpressionTranslator.translateLogicalOperator(operator), (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    public final Expression NegationExpression() throws ParseException {
        Token operator = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                operator = this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        Expression expression = this.RelationalExpression();
        if (operator != null) {
            return PMMLUtil.createApply((String)"not", (Expression[])new Expression[]{expression});
        }
        return expression;
    }

    public final Expression RelationalExpression() throws ParseException {
        Expression left = this.AdditiveExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                Token operator;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 17: {
                        operator = this.jj_consume_token(17);
                        break;
                    }
                    case 18: {
                        operator = this.jj_consume_token(18);
                        break;
                    }
                    case 19: {
                        operator = this.jj_consume_token(19);
                        break;
                    }
                    case 20: {
                        operator = this.jj_consume_token(20);
                        break;
                    }
                    case 21: {
                        operator = this.jj_consume_token(21);
                        break;
                    }
                    case 22: {
                        operator = this.jj_consume_token(22);
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Expression right = this.AdditiveExpression();
                left = PMMLUtil.createApply((String)ExpressionTranslator.translateRelationalOperator(operator), (Expression[])new Expression[]{left, right});
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        return left;
    }

    public final Expression AdditiveExpression() throws ParseException {
        Expression left = this.MultiplicativeExpression();
        block7: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    operator = this.jj_consume_token(3);
                    break;
                }
                case 4: {
                    operator = this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.MultiplicativeExpression();
            left = PMMLUtil.createApply((String)ExpressionTranslator.translateArithmeticOperator(operator), (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    public final Expression MultiplicativeExpression() throws ParseException {
        Expression left = this.UnaryExpression();
        block8: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    operator = this.jj_consume_token(5);
                    break;
                }
                case 6: {
                    operator = this.jj_consume_token(6);
                    break;
                }
                case 7: {
                    operator = this.jj_consume_token(7);
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.UnaryExpression();
            left = PMMLUtil.createApply((String)ExpressionTranslator.translateArithmeticOperator(operator), (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    public final Expression UnaryExpression() throws ParseException {
        Token sign = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 3: 
            case 4: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: {
                        sign = this.jj_consume_token(3);
                        break block0;
                    }
                    case 4: {
                        sign = this.jj_consume_token(4);
                        break block0;
                    }
                }
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        Expression expression = this.ExponentiationExpression();
        if (sign != null && sign.kind == 4) {
            expression = PMMLUtil.toNegative((Expression)expression);
        }
        return expression;
    }

    public final Expression ExponentiationExpression() throws ParseException {
        Token operator = null;
        Expression right = null;
        Expression left = this.PrimaryExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: 
            case 9: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: {
                        operator = this.jj_consume_token(8);
                        break;
                    }
                    case 9: {
                        operator = this.jj_consume_token(9);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                right = this.UnaryExpression();
                left = PMMLUtil.createApply((String)"pow", (Expression[])new Expression[]{left, right});
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        return left;
    }

    public final Expression PrimaryExpression() throws ParseException {
        Expression expression;
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            expression = this.FunctionInvocationExpression();
        } else if (this.jj_2_4(Integer.MAX_VALUE)) {
            expression = this.FunctionInvocationExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 48: {
                    expression = this.FieldInvocationExpression();
                    break;
                }
                case 10: {
                    expression = this.ParenthesizedExpression();
                    break;
                }
                case 36: 
                case 37: 
                case 43: 
                case 45: 
                case 46: 
                case 47: 
                case 49: {
                    expression = this.Constant();
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expression;
    }

    public final Expression FunctionInvocationExpression() throws ParseException {
        Token end;
        List<FunctionExpression.Argument> arguments;
        Token begin;
        Token function;
        Token namespace = null;
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            namespace = this.jj_consume_token(48);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: {
                    this.jj_consume_token(25);
                    break;
                }
                case 26: {
                    this.jj_consume_token(26);
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            function = this.jj_consume_token(48);
            begin = this.jj_consume_token(10);
            arguments = this.ArgumentList();
            end = this.jj_consume_token(11);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 48: {
                    function = this.jj_consume_token(48);
                    begin = this.jj_consume_token(10);
                    arguments = this.ArgumentList();
                    end = this.jj_consume_token(11);
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (arguments.size() > 0) {
            FunctionExpression.Argument firstArgument = arguments.get(0);
            firstArgument.setBegin(begin);
            FunctionExpression.Argument lastArgument = arguments.get(arguments.size() - 1);
            lastArgument.setEnd(end);
        }
        try {
            FunctionExpression.Argument argument;
            String pmmlFunction = ExpressionTranslator.translateFunction(function.image);
            if (arguments.size() == 1 && !(argument = arguments.get(0)).hasTag() && !(argument.getExpression() instanceof FunctionExpression)) {
                return PMMLUtil.createApply((String)pmmlFunction, (Expression[])new Expression[]{argument.getExpression()});
            }
        }
        catch (IllegalArgumentException pmmlFunction) {
            // empty catch block
        }
        FunctionExpression functionExpression = namespace != null ? new FunctionExpression(namespace.image, function.image, arguments) : new FunctionExpression(function.image, arguments);
        return functionExpression;
    }

    private final List<FunctionExpression.Argument> ArgumentList() throws ParseException {
        ArrayList<FunctionExpression.Argument> arguments = new ArrayList<FunctionExpression.Argument>();
        FunctionExpression.Argument argument = this.Argument();
        arguments.add(argument);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            Token comma = this.jj_consume_token(24);
            argument.setEnd(comma);
            argument = this.Argument();
            argument.setBegin(comma);
            arguments.add(argument);
        }
        return arguments;
    }

    private final FunctionExpression.Argument Argument() throws ParseException {
        Expression expression;
        Token tag = null;
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            tag = this.jj_consume_token(48);
            this.jj_consume_token(23);
            expression = this.Expression();
        } else if (this.jj_2_7(Integer.MAX_VALUE)) {
            tag = this.jj_consume_token(49);
            this.jj_consume_token(23);
            expression = this.Expression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: 
                case 4: 
                case 10: 
                case 16: 
                case 31: 
                case 36: 
                case 37: 
                case 43: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    expression = this.Expression();
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        FunctionExpression.Argument argument = tag != null ? new FunctionExpression.Argument(ExpressionTranslator.translateTag(tag), expression) : new FunctionExpression.Argument(expression);
        return argument;
    }

    public final FieldRef FieldInvocationExpression() throws ParseException {
        Token name = this.jj_consume_token(48);
        FieldRef fieldRef = new FieldRef().setField(FieldName.create((String)name.image));
        return fieldRef;
    }

    public final Expression ParenthesizedExpression() throws ParseException {
        this.jj_consume_token(10);
        Expression expression = this.Expression();
        this.jj_consume_token(11);
        return expression;
    }

    public final Constant Constant() throws ParseException {
        DataType dataType;
        Token value;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 46: {
                value = this.jj_consume_token(46);
                dataType = DataType.INTEGER;
                break;
            }
            case 37: 
            case 43: 
            case 47: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 47: {
                        value = this.jj_consume_token(47);
                        break;
                    }
                    case 37: {
                        value = this.jj_consume_token(37);
                        break;
                    }
                    case 43: {
                        value = this.jj_consume_token(43);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                dataType = DataType.DOUBLE;
                break;
            }
            case 36: 
            case 45: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 36: {
                        value = this.jj_consume_token(36);
                        break;
                    }
                    case 45: {
                        value = this.jj_consume_token(45);
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                dataType = DataType.BOOLEAN;
                break;
            }
            case 49: {
                value = this.jj_consume_token(49);
                dataType = DataType.STRING;
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Constant constant = new Constant().setValue((Object)ExpressionTranslator.translateValue(value)).setDataType(dataType);
        return constant;
    }

    private final Interval translateIntervalInternal() throws ParseException {
        Interval interval = this.Interval();
        this.jj_consume_token(0);
        return interval;
    }

    public final Interval Interval() throws ParseException {
        Token rightBound;
        Token leftBound;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: {
                leftBound = this.jj_consume_token(10);
                break;
            }
            case 12: {
                leftBound = this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Double leftMargin = this.SignedNumber();
        this.jj_consume_token(24);
        Double rightMargin = this.SignedNumber();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                rightBound = this.jj_consume_token(11);
                break;
            }
            case 13: {
                rightBound = this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Interval interval = new Interval(ExpressionTranslator.translateClosure(leftBound.image, rightBound.image)).setLeftMargin((Number)ExpressionTranslator.filterMargin(leftMargin)).setRightMargin((Number)ExpressionTranslator.filterMargin(rightMargin));
        return interval;
    }

    private final Double SignedNumber() throws ParseException {
        Token value;
        Token sign = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 3: 
            case 4: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: {
                        sign = this.jj_consume_token(3);
                        break block0;
                    }
                    case 4: {
                        sign = this.jj_consume_token(4);
                        break block0;
                    }
                }
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 46: {
                value = this.jj_consume_token(46);
                break;
            }
            case 47: {
                value = this.jj_consume_token(47);
                break;
            }
            case 37: {
                value = this.jj_consume_token(37);
                break;
            }
            case 43: {
                value = this.jj_consume_token(43);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String javaValue = ExpressionTranslator.translateValue(value);
        if (sign != null && sign.kind == 4) {
            javaValue = "-" + javaValue;
        }
        return Double.valueOf(javaValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(25)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(26)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        return this.jj_scan_token(10);
    }

    private boolean jj_3_1() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(25)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(26)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{66584, 32768, 16384, 65536, 0x7E0000, 0x7E0000, 24, 24, 224, 224, 24, 24, 768, 768, 1024, 0x6000000, 0, 0x1000000, -2147417064, 0, 0, 0, 5120, 10240, 24, 24, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{256048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256048, 0, 65536, 0, 256048, 34848, 8208, 190512, 0, 0, 0, 0, 51232};
    }

    public ExpressionTranslator(Provider stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ExpressionTranslatorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ExpressionTranslatorTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionTranslator(ExpressionTranslatorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ExpressionTranslatorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[54];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 27; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 54; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : ExpressionTranslatorTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 7; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ExpressionTranslator.jj_la1_init_0();
        ExpressionTranslator.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }
    }
}

