% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traceplots.R
\name{traceplots}
\alias{traceplots}
\title{Create Traceplots for the Parameters}
\usage{
traceplots(input, columns, pre_model = FALSE, stan = FALSE)
}
\arguments{
\item{input}{list List of the model output}

\item{columns}{vector The target columns to assess}

\item{pre_model}{bool If you are passing the pre-model}

\item{stan}{bool If the model is stan based}
}
\value{
plotted objects
}
\description{
Create sampler traceplots to run diagnostics on whether or
not the sampler converged when creating the posterior. Columns
should always be in the order that they appear in the model.
}
\examples{
columns <- c("fruit", "veg", "tobacco")
fruit_v_coef <- generate_coefficient(100, 0.3, 0.8, 0.95)
veg_v_coef <- generate_coefficient(100, 0.25, 0.75, 0.95)
tob_v_coef <- generate_coefficient(100, 0.4, 0.7, 0.95)
validity_coefficients <- c(fruit_v_coef, veg_v_coef, tob_v_coef)
data <- data.frame(
 list(
   "BMI" = rnorm(100, mean = 0, sd = 1),
   "fruit" = rnorm(100, mean = 0, sd = 1),
   "veg" = rnorm(100, mean = 0, sd = 1),
   "tobacco" = rnorm(100, mean = 0, sd = 1)
 )
)
output <- acme_model(data, columns)
lambda <- attenuation_matrix(
  output,
  columns,
  validity_coefficients,
)
model_output <- multivariate_model(
  "BMI ~ fruit + veg + tobacco",
  data = data,
  columns = columns,
  a_c_matrix = lambda$matrix,
  sds = lambda$sds,
  variances = lambda$variances,
  univariate = TRUE
)
traceplots(model_output$naive, columns)
}
