% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruning.R
\name{pruning}
\alias{pruning}
\title{A Pruning function}
\usage{
pruning(train, rules, method = "m2cba")
}
\arguments{
\item{train}{data.frame with training data}

\item{rules}{data.frame with rules}

\item{method}{pruning method m2cba(default)|m1cba|dcbrcba}
}
\value{
data.frame with pruned rules
}
\description{
A Pruning function
}
\examples{
library("arules")
library("rCBA")
data("iris")

train <- sapply(iris,as.factor)
train <- data.frame(train, check.names=FALSE)
txns <- as(train,"transactions")

rules = apriori(txns, parameter=list(support=0.03, confidence=0.03, minlen=2), 
appearance = list(rhs=c("Species=setosa", "Species=versicolor", "Species=virginica"),default="lhs"))
rulesFrame <- as(rules,"data.frame")

print(nrow(rulesFrame))
prunedRulesFrame <- pruning(train, rulesFrame, method="m2cba")
print(nrow(prunedRulesFrame))
}

