% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqs_transactionssample.R
\name{aqs_transactionssample}
\alias{aqs_transactionssample}
\alias{transactionssample_bysite}
\alias{transactionssample_bycounty}
\alias{transactionssample_bystate}
\alias{transactionssample_byma}
\title{AQS API Sample Data Transaction service}
\usage{
aqs_transactionssample(
  aqs_filter = c("bySite", "byCounty", "byState", "byMA"),
  aqs_variables = NULL,
  header = FALSE,
  ...
)

transactionssample_bysite(
  param,
  bdate,
  edate,
  state,
  county,
  site,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

transactionssample_bycounty(
  param,
  bdate,
  edate,
  state,
  county,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

transactionssample_bystate(
  param,
  bdate,
  edate,
  state,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

transactionssample_byma(
  param,
  bdate,
  edate,
  agency,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)
}
\arguments{
\item{aqs_filter}{A string specifying one of the service filters. NOT
case-sensitive.}

\item{aqs_variables}{A named list of variables to fetch data (e.g.,
\code{state}). Only necessary variables are passed to a specific endpoint
(service/filter) to make a valid request.}

\item{header}{A logical specifying whether the function returns additional
information from the API header. Default is \code{FALSE} to return data only.}

\item{...}{Reserved for future use.}

\item{param}{A string or vector of strings specifying the 5-digit AQS
parameter code for data selection. An integer will be coerced to a string.
A maximum of 5 parameter codes may be listed in a single request. A list
of the parameter codes can be obtained via \link{list_parametersbyclass}.}

\item{bdate}{A string specifying the begin date of data selection in
YYYYMMDD format. Only data on or after this date will be returned.}

\item{edate}{A string specifying the end date of data selection in YYYYMMDD
format. Only data on or before this date will be returned. If the end date
is not in the same year as the begin date, the function will automatically
split the date range into multiple chunks by year and send requests
sequentially.}

\item{state}{A string specifying the 2-digit state FIPS code. An integer
will be coerced to a string with a leading zero if necessary (e.g., 1 ->
"01"). A list of the state codes can be obtained via \link{list_states}.}

\item{county}{A string specifying the 3-digit county FIPS code. An integer
will be coerced to a string with leading zeros if necessary (e.g., 89 ->
"089"). A list of the county codes within each state can be obtained via
\link{list_countiesbystate}.}

\item{site}{A string specifying the 4-digit AQS site number within the
county. An integer will be coerced to a string with leading zeros if
necessary (e.g., 14 -> "0014"). A list of the site codes within each
county can be obtained via \link{list_sitesbycounty}.}

\item{email}{A string specifying the email address of the requester. If you
set your email and key with \link{set_aqs_user}, you don't have to specify
this.}

\item{key}{A string specifying the key matching the email address for the
requester. If you set your email and key with \link{set_aqs_user}, you don't
have to specify this.}

\item{agency}{A string specifying the AQS Monitoring Agency (MA) code. A
list of the MA codes can be obtained via \link{list_mas}. Here, we named this
input as \code{agency} instead of "ma" because \code{agency} is actually used in the
API endpoint URL.}
}
\value{
A data.frame containing parsed data or a named list containing
header and data.
}
\description{
A collection of functions to fetch data in the submission (transaction)
format for AQS.
}
\details{
\link{aqs_transactionssample} sends a request to the AQS API based on a
user-provided filter using the following underlying functions:
\itemize{
\item \link{transactionssample_bysite} returns all \code{param} data for \code{site} in
\code{county}, within \code{state}, between \code{bdate} and \code{edate} in the transaction
format.
\item \link{transactionssample_bycounty} returns all \code{param} data for \code{county} in
\code{state} between \code{bdate} and \code{edate} in the transaction format.
\item \link{transactionssample_bystate} returns all \code{param} data in \code{state} between
\code{bdate} and \code{edate} in the transaction format.
\item \link{transactionssample_byma} returns all \code{param} data in \code{agency} (monitoring
agency) between \code{bdate} and \code{edate} in the transaction format.
}
}
\examples{
\dontrun{

## Set your API Key first using set_aqs_user to run the following codes

## Example from the AQS website
## all benzene samples from North Carolina collected on May 15th, 1995
aqs_variables <- list(
  param = "45201", bdate = "19950515", edate = "19950515",
  state = "37"
)
aqs_transactionssample(
  aqs_filter = "byState", aqs_variables = aqs_variables
)

## Equivalent to above; used integers instead of strings
transactionssample_bystate(
  param = 45201, bdate = "19950515", edate = "19950515",
  state = 37
)
}

}
