% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_reorient.R
\name{render_reorient}
\alias{render_reorient}
\title{Reorient Image}
\usage{
render_reorient(
  image,
  flipx = FALSE,
  flipy = FALSE,
  transpose = FALSE,
  filename = NULL,
  preview = FALSE
)
}
\arguments{
\item{image}{Image filename, 3-layer RGB array, or matrix.}

\item{flipx}{Default \code{FALSE}. Flip horizontally}

\item{flipy}{Default \code{FALSE}. Flip vertically.}

\item{transpose}{Default \code{FALSE}. Transpose image.}

\item{filename}{Default \code{NULL}. The filename of the image to be saved. If this is not given, the image will be plotted instead.}

\item{preview}{Default \code{FALSE}. Whether to plot the convolved image, or just to return the values.}
}
\value{
3-layer RGB reoriented array or matrix.
}
\description{
Reorients an image or matrix. Transformations are applied in this order: x, y, and transpose.
}
\examples{
#Original orientation
\donttest{
plot_image(dragon)
}

#Flip the dragon image horizontally
\donttest{
dragon \%>\%
 render_reorient(flipx = TRUE) \%>\%
 plot_image()
}

#Flip the dragon image vertically
\donttest{
dragon \%>\%
 render_reorient(flipy = TRUE) \%>\%
 plot_image()
}

#'#Transpose the dragon image
\donttest{
dragon \%>\%
 render_reorient(transpose = TRUE) \%>\%
 plot_image()
}
}
