% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biom_merge.r
\name{biom_merge}
\alias{biom_merge}
\title{Combine several rbiom objects into one.}
\usage{
biom_merge(
  ...,
  metadata = NA,
  taxonomy = NA,
  tree = NULL,
  sequences = NA,
  id = NA,
  comment = NA
)
}
\arguments{
\item{...}{Any number of rbiom objects (e.g. from \code{\link[=as_rbiom]{as_rbiom()}}), lists of
rbiom objects, or valid arguments to the \code{biom} parameter of
\code{\link[=as_rbiom]{as_rbiom()}} (for instance file names).}

\item{metadata, taxonomy, tree, sequences, id, comment}{Replace the corresponding
data in the merged rbiom object with these values. Set to \code{NULL} to
not inherit a particular component. The default, \code{NA}, will attempt
to create the component based on \code{...} values. The merged
phylogenetic tree cannot be inferred.}
}
\value{
An \link[=rbiom_objects]{rbiom object}.
}
\description{
WARNING: It is generally ill-advised to merge BIOM datasets, as OTUs
mappings are dependent on upstream clustering and are not equivalent
between BIOM files.
}
\examples{
    library(rbiom)
    
    b1 <- as_rbiom(hmp50$counts[,1:4])
    b2 <- as_rbiom(hmp50$counts[,5:8])
    
    biom <- biom_merge(b1, b2)
    print(biom)
    
    biom$tree     <- hmp50$tree
    biom$metadata <- hmp50$metadata
    print(biom)
}
\seealso{
Other biom: 
\code{\link{bdply}()}
}
\concept{biom}
