% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.r
\name{pull.rbiom}
\alias{pull.rbiom}
\title{Map sample names to metadata field values.}
\usage{
\method{pull}{rbiom}(.data, var = -1, name = ".sample", ...)
}
\arguments{
\item{.data}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.}

\item{var}{The metadata field name specified as:
\itemize{
\item{The metadata field name to retrieve. Can be abbreviated.}
\item{A positive integer, giving the position counting from the left.}
\item{A negative integer, giving the position counting from the right.}
}
Default: \code{-1}}

\item{name}{The column to be used as names for a named vector.
Specified in a similar manner as var. Default: \code{".sample"}}

\item{...}{Not used.}
}
\value{
A vector of metadata values, named with sample names.
}
\description{
Map sample names to metadata field values.
}
\examples{
    library(rbiom)
    
    pull(hmp50, 'Age') \%>\% head()
    
    pull(hmp50, 'bod') \%>\% head(4)
    
}
\seealso{
\code{taxa_map()}

Other samples: 
\code{\link{sample_sums}()}
}
\concept{samples}
