% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_table.r
\name{stats_table}
\alias{stats_table}
\title{Run non-parametric statistics on a data.frame.}
\usage{
stats_table(
  df,
  regr = NULL,
  resp = attr(df, "response"),
  stat.by = NULL,
  split.by = NULL,
  test = "emmeans",
  fit = "gam",
  at = NULL,
  level = 0.95,
  alt = "!=",
  mu = 0,
  p.adj = "fdr"
)
}
\arguments{
\item{df}{The dataset (data.frame or tibble object). "Dataset fields"
mentioned below should match column names in \code{df}. Required.}

\item{regr}{Dataset field with the x-axis (independent; predictive)
values. Must be numeric. Default: \code{NULL}}

\item{resp}{Dataset field with the y-axis (dependent; response) values,
such as taxa abundance or alpha diversity.
Default: \code{attr(df, 'response')}}

\item{stat.by}{Dataset field with the statistical groups. Must be
categorical. Default: \code{NULL}}

\item{split.by}{Dataset field(s) that the data should be split by prior to
any calculations. Must be categorical. Default: \code{NULL}}

\item{test}{Method for computing p-values: \code{'wilcox'}, \code{'kruskal'},
\code{'emmeans'}, or \code{'emtrends'}. Default: \code{'emmeans'}}

\item{fit}{How to fit the trendline. \code{'lm'}, \code{'log'}, or \code{'gam'}.
Default: \code{'gam'}}

\item{at}{Position(s) along the x-axis where the means or slopes should be
evaluated. Default: \code{NULL}, which samples 100 evenly spaced positions
and selects the position where the p-value is most significant.}

\item{level}{The confidence level for calculating a confidence interval.
Default: \code{0.95}}

\item{alt}{Alternative hypothesis direction. Options are \code{'!='}
(two-sided; not equal to \code{mu}), \code{'<'} (less than \code{mu}), or \code{'>'}
(greater than \code{mu}). Default: \code{'!='}}

\item{mu}{Reference value to test against. Default: \code{0}}

\item{p.adj}{Method to use for multiple comparisons adjustment of
p-values. Run \code{p.adjust.methods} for a list of available
options. Default: \code{"fdr"}}
}
\value{
A tibble data.frame with fields from the table below. This tibble
object provides the \verb{$code} operator to print the R code used to generate
the statistics.\tabular{ll}{
   \strong{Field} \tab \strong{Description} \cr
   .mean \tab Estimated marginal mean. See \code{\link[emmeans:emmeans]{emmeans::emmeans()}}. \cr
   .mean.diff \tab Difference in means. \cr
   .slope \tab Trendline slope. See \code{\link[emmeans:emtrends]{emmeans::emtrends()}}. \cr
   .slope.diff \tab Difference in slopes. \cr
   .h1 \tab Alternate hypothesis. \cr
   .p.val \tab Probability that null hypothesis is correct. \cr
   .adj.p \tab \code{.p.val} after adjusting for multiple comparisons. \cr
   .effect.size \tab Effect size. See \code{\link[emmeans:eff_size]{emmeans::eff_size()}}. \cr
   .lower \tab Confidence interval lower bound. \cr
   .upper \tab Confidence interval upper bound. \cr
   .se \tab Standard error. \cr
   .n \tab Number of samples. \cr
   .df \tab Degrees of freedom. \cr
   .stat \tab Wilcoxon or Kruskal-Wallis rank sum statistic. \cr
   .t.ratio \tab \code{.mean} / \code{.se} \cr
   .r.sqr \tab Percent of variation explained by the model. \cr
   .adj.r \tab \code{.r.sqr}, taking degrees of freedom into account. \cr
   .aic \tab Akaike Information Criterion (predictive models). \cr
   .bic \tab Bayesian Information Criterion (descriptive models). \cr
   .loglik \tab Log-likelihood goodness-of-fit score. \cr
   .fit.p \tab P-value for observing this fit by chance. \cr
}
}
\description{
A simple interface to lower-level statistics functions, including
\code{\link[stats:wilcox.test]{stats::wilcox.test()}}, \code{\link[stats:kruskal.test]{stats::kruskal.test()}}, \code{\link[emmeans:emmeans]{emmeans::emmeans()}},
and \code{\link[emmeans:emtrends]{emmeans::emtrends()}}.
}
\examples{
    library(rbiom)
    
    biom <- rarefy(hmp50)
    
    df <- taxa_table(biom, rank = "Family")
    stats_table(df, stat.by = "Body Site")[,1:6]
    
    df <- adiv_table(biom)
    stats_table(df, stat.by = "Sex", split.by = "Body Site")[,1:7]
}
\seealso{
Other stats_tables: 
\code{\link{adiv_stats}()},
\code{\link{bdiv_stats}()},
\code{\link{distmat_stats}()},
\code{\link{taxa_stats}()}
}
\concept{stats_tables}
