% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa_heatmap.r
\name{taxa_heatmap}
\alias{taxa_heatmap}
\title{Display taxa abundances as a heatmap.}
\usage{
taxa_heatmap(
  biom,
  rank = -1,
  taxa = 6,
  tracks = NULL,
  grid = "bilbao",
  other = FALSE,
  unc = "singly",
  lineage = FALSE,
  label = TRUE,
  label_size = NULL,
  rescale = "none",
  trees = TRUE,
  clust = "complete",
  dist = "euclidean",
  asp = 1,
  tree_height = 10,
  track_height = 10,
  legend = "right",
  title = TRUE,
  xlab.angle = "auto",
  ...
)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{rank}{What rank(s) of taxa to display. E.g. \code{"Phylum"},
\code{"Genus"}, \code{".otu"}, etc. An integer vector can also be
given, where \code{1} is the highest rank, \code{2} is the second
highest, \code{-1} is the lowest rank, \code{-2} is the second
lowest, and \code{0} is the OTU "rank". Run \code{biom$ranks} to
see all options for a given rbiom object. Default: \code{-1}.}

\item{taxa}{Which taxa to display. An integer value will show the top n
most abundant taxa. A value 0 <= n < 1 will show any taxa with that
mean abundance or greater (e.g. \code{0.1} implies >= 10\%). A
character vector of taxa names will show only those named taxa.
Default: \code{6}.}

\item{tracks}{A character vector of metadata fields to display as tracks
at the top of the plot. Or, a list as expected by the \code{tracks}
argument of \code{\link[=plot_heatmap]{plot_heatmap()}}. Default: \code{NULL}}

\item{grid}{Color palette name, or a list as expected \code{\link[=plot_heatmap]{plot_heatmap()}}.
Default: \code{"bilbao"}}

\item{other}{Sum all non-itemized taxa into an "Other" taxa. When
\code{FALSE}, only returns taxa matched by the \code{taxa}
argument. Specifying \code{TRUE} adds "Other" to the returned set.
A string can also be given to imply \code{TRUE}, but with that
value as the name to use instead of "Other".
Default: \code{FALSE}}

\item{unc}{How to handle unclassified, uncultured, and similarly ambiguous
taxa names. Options are:
\describe{
\item{\code{"singly"} - }{ Replaces them with the OTU name. }
\item{\code{"grouped"} - }{ Replaces them with a higher rank's name. }
\item{\code{"drop"} - }{ Excludes them from the result. }
\item{\code{"asis"} - }{ To not check/modify any taxa names. }
}
Abbreviations are allowed. Default: \code{"singly"}}

\item{lineage}{Include all ranks in the name of the taxa. For instance,
setting to \code{TRUE} will produce
\verb{Bacteria; Actinobacteria; Coriobacteriia; Coriobacteriales}.
Otherwise the taxa name will simply be \code{Coriobacteriales}. You
want to set this to TRUE when \code{unc = "asis"} and you have taxa
names (such as \emph{Incertae_Sedis}) that map to multiple higher
level ranks. Default: \code{FALSE}}

\item{label}{Label the matrix rows and columns. You can supply a list
or logical vector of length two to control row labels and column
labels separately, for example
\code{label = c(rows = TRUE, cols = FALSE)}, or simply
\code{label = c(TRUE, FALSE)}. Other valid options are \code{"rows"},
\code{"cols"}, \code{"both"}, \code{"bottom"}, \code{"right"},
and \code{"none"}.
Default: \code{TRUE}}

\item{label_size}{The font size to use for the row and column labels. You
can supply a numeric vector of length two to control row label sizes
and column label sizes separately, for example
\code{c(rows = 20, cols = 8)}, or simply \code{c(20, 8)}.
Default: \code{NULL}, which computes:
\code{pmax(8, pmin(20, 100 / dim(mtx)))}}

\item{rescale}{Rescale rows or columns to all have a common min/max.
Options: \code{"none"}, \code{"rows"}, or \code{"cols"}.
Default: \code{"none"}}

\item{trees}{Draw a dendrogram for rows (left) and columns (top). You can
supply a list or logical vector of length two to control the row tree
and column tree separately, for example
\code{trees = c(rows = TRUE, cols = FALSE)},
or simply \code{trees = c(TRUE, FALSE)}.
Other valid options are \code{"rows"}, \code{"cols"}, \code{"both"},
\code{"left"}, \code{"top"}, and \code{"none"}.
Default: \code{TRUE}}

\item{clust}{Clustering algorithm for reordering the rows and columns by
similarity. You can supply a list or character vector of length two to
control the row and column clustering separately, for example
\code{clust = c(rows = "complete", cols = NA)}, or simply
\code{clust = c("complete", NA)}. Options are:
\describe{
\item{\code{FALSE} or \code{NA} - }{ Disable reordering. }
\item{An \code{hclust} class object}{ E.g. from \code{\link[stats:hclust]{stats::hclust()}}. }
\item{A method name - }{ \code{"ward.D"},
\code{"ward.D2"}, \code{"single"}, \code{"complete"},
\code{"average"}, \code{"mcquitty"}, \code{"median"}, or
\code{"centroid"}. }
}
Default: \code{"complete"}}

\item{dist}{Distance algorithm to use when reordering the rows and columns
by similarity. You can supply a list or character vector of length
two to control the row and column clustering separately, for example
\code{dist = c(rows = "euclidean", cols = "maximum")}, or simply
\code{dist = c("euclidean", "maximum")}. Options are:
\describe{
\item{A \code{dist} class object}{ E.g. from \code{\link[stats:dist]{stats::dist()}} or \code{\link[=bdiv_distmat]{bdiv_distmat()}}. }
\item{A method name - }{ \code{"euclidean"},
\code{"maximum"}, \code{"manhattan"}, \code{"canberra"},
\code{"binary"}, or \code{"minkowski"}. }
}
Default: \code{"euclidean"}}

\item{asp}{Aspect ratio (height/width) for entire grid.
Default: \code{1} (square)}

\item{tree_height, track_height}{The height of the dendrogram or annotation
tracks as a percentage of the overall grid size. Use a numeric vector
of length two to assign \code{c(top, left)} independently.
Default: \code{10} (10\% of the grid's height)}

\item{legend}{Where to place the legend. Options are: \code{"right"} or
\code{"bottom"}. Default: \code{"right"}}

\item{title}{Plot title. Set to \code{TRUE} for a default title, \code{NULL} for
no title, or any character string. Default: \code{TRUE}}

\item{xlab.angle}{Angle of the labels at the bottom of the plot.
Options are \code{"auto"}, \code{'0'}, \code{'30'}, and \code{'90'}.
Default: \code{"auto"}.}

\item{...}{Additional arguments to pass on to ggplot2::theme().}
}
\value{
A \code{ggplot2} plot. The computed data points and ggplot
command are available as \verb{$data} and \verb{$code},
respectively.
}
\description{
Display taxa abundances as a heatmap.
}
\section{Annotation Tracks}{


Metadata can be displayed as colored tracks above the heatmap. Common use
cases are provided below, with more thorough documentation available at
https://cmmr.github.io/rbiom .

\preformatted{## Categorical ----------------------------
tracks = "Body Site"
tracks = list('Body Site' = "bright")
tracks = list('Body Site' = c('Stool' = "blue", 'Saliva' = "green"))

## Numeric --------------------------------
tracks = "Age"
tracks = list('Age' = "reds")

## Multiple Tracks ------------------------
tracks = c("Body Site", "Age")
tracks = list('Body Site' = "bright", 'Age' = "reds")
tracks = list(
  'Body Site' = c('Stool' = "blue", 'Saliva' = "green"),
  'Age'       = list('colors' = "reds") )
}

The following entries in the track definitions are understood:

\describe{
\item{\code{colors} - }{ A pre-defined palette name or custom set of colors to map to. }
\item{\code{range} - }{ The c(min,max) to use for scale values. }
\item{\code{label} - }{ Label for this track. Defaults to the name of this list element. }
\item{\code{side} - }{ Options are \code{"top"} (default) or \code{"left"}. }
\item{\code{na.color} - }{ The color to use for \code{NA} values. }
\item{\code{bins} - }{ Bin a gradient into this many bins/steps. }
\item{\code{guide} - }{ A list of arguments for guide_colorbar() or guide_legend(). }
}

All built-in color palettes are colorblind-friendly.

Categorical palette names: \code{"okabe"}, \code{"carto"}, \code{"r4"},
\code{"polychrome"}, \code{"tol"}, \code{"bright"}, \code{"light"},
\code{"muted"}, \code{"vibrant"}, \code{"tableau"}, \code{"classic"},
\code{"alphabet"}, \code{"tableau20"}, \code{"kelly"}, and \code{"fishy"}.

Numeric palette names: \code{"reds"}, \code{"oranges"}, \code{"greens"},
\code{"purples"}, \code{"grays"}, \code{"acton"}, \code{"bamako"},
\code{"batlow"}, \code{"bilbao"}, \code{"buda"}, \code{"davos"},
\code{"devon"}, \code{"grayC"}, \code{"hawaii"}, \code{"imola"},
\code{"lajolla"}, \code{"lapaz"}, \code{"nuuk"}, \code{"oslo"},
\code{"tokyo"}, \code{"turku"}, \code{"bam"}, \code{"berlin"},
\code{"broc"}, \code{"cork"}, \code{"lisbon"}, \code{"roma"},
\code{"tofino"}, \code{"vanimo"}, and \code{"vik"}.
}

\examples{
    library(rbiom)
    
    # Keep and rarefy the 10 most deeply sequenced samples.
    hmp10 <- rarefy(hmp50, n = 10)
    
    taxa_heatmap(hmp10, rank = "Phylum", tracks = "Body Site")
    
    taxa_heatmap(hmp10, rank = "Genus", tracks = c("sex", "bo"))
    
    taxa_heatmap(hmp10, rank = "Phylum", tracks = list(
      'Sex'       = list(colors = c(m = "#0000FF", f = "violetred")), 
      'Body Site' = list(colors = "muted", label = "Source") ))
    
}
\seealso{
Other taxa_abundance: 
\code{\link{sample_sums}()},
\code{\link{taxa_boxplot}()},
\code{\link{taxa_clusters}()},
\code{\link{taxa_corrplot}()},
\code{\link{taxa_stacked}()},
\code{\link{taxa_stats}()},
\code{\link{taxa_sums}()},
\code{\link{taxa_table}()}

Other visualization: 
\code{\link{adiv_boxplot}()},
\code{\link{adiv_corrplot}()},
\code{\link{bdiv_boxplot}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_heatmap}()},
\code{\link{bdiv_ord_plot}()},
\code{\link{plot_heatmap}()},
\code{\link{rare_corrplot}()},
\code{\link{rare_multiplot}()},
\code{\link{rare_stacked}()},
\code{\link{stats_boxplot}()},
\code{\link{stats_corrplot}()},
\code{\link{taxa_boxplot}()},
\code{\link{taxa_corrplot}()},
\code{\link{taxa_stacked}()}
}
\concept{taxa_abundance}
\concept{visualization}
