% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_rcdf.R
\name{write_rcdf}
\alias{write_rcdf}
\title{Write data to RCDF format}
\usage{
write_rcdf(
  data,
  path,
  pub_key,
  ...,
  metadata = list(),
  ignore_duplicates = TRUE
)
}
\arguments{
\item{data}{A list of data frames or tables to be written to RCDF format. Each element of the list represents a record.}

\item{path}{The path where the RCDF file will be written. The file will be saved with a \code{.rcdf} extension if not already specified.}

\item{pub_key}{The public RSA key used to encrypt the AES encryption keys.}

\item{...}{Additional arguments passed to helper functions if needed.}

\item{metadata}{A list of metadata to be included in the RCDF file.}

\item{ignore_duplicates}{A \code{logical} flag. If \code{TRUE}, a warning is issued when duplicates are found. If \code{FALSE}, the function stops with an error.}
}
\value{
NULL. The function writes the data to a \code{.rcdf} file at the specified path.
}
\description{
This function writes data to an RCDF (Reusable Data Container Format) archive. It encrypts the data using AES, generates metadata,
and then creates a zip archive containing both the encrypted Parquet files and metadata. The function supports the inclusion of
metadata such as system information and encryption keys.
}
\examples{
# Example usage of writing an RCDF file

rcdf_data <- rcdf_list()
rcdf_data$mtcars <- mtcars

dir <- system.file("extdata", package = "rcdf")

temp_dir <- tempdir()

write_rcdf(
  data = rcdf_data,
  path = file.path(temp_dir, "mtcars.rcdf"),
  pub_key = file.path(dir, 'sample-public-key.pem')
)

write_rcdf(
  data = rcdf_data,
  path = file.path(temp_dir, "mtcars-pw.rcdf"),
  pub_key = file.path(dir, 'sample-public-key-pw.pem')
)

unlink(file.path(temp_dir, "mtcars.rcdf"), force = TRUE)
unlink(file.path(temp_dir, "mtcars-pw.rcdf"), force = TRUE)
}
