% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reproject}
\alias{reproject}
\title{Reproject a raster or vector dataset to the specified
coordinate reference system (CRS)}
\usage{
reproject(x, crs, ...)
}
\arguments{
\item{x}{Raster or vector object}

\item{crs}{CRS to be projected to}

\item{...}{Optional arguments for raster or vector reproject functions}
}
\value{
Object reprojected to specified CRS
}
\description{
Reproject a raster or vector dataset to the specified
coordinate reference system (CRS)
}
\examples{
# Reproject a raster to EPSG:4326
r <- terra::rast(matrix(1:12, nrow = 3, ncol = 4), crs = "EPSG:32633")
reproject(r, 4326)
}
