% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocs.R
\name{ocs_create_share}
\alias{ocs_create_share}
\alias{ocs_create_share_link}
\alias{ocs_create_share_mail}
\alias{ocs_create_share_user}
\alias{ocs_create_share_group}
\alias{ocs_create_share_federated}
\title{Creates a share}
\usage{
ocs_create_share(
  req,
  path,
  share_type,
  share_with = NULL,
  password = NULL,
  permissions = 1,
  public_upload = FALSE,
  expire_date = NULL,
  label = "",
  note = "",
  send_mail = FALSE,
  attributes = NULL
)

ocs_create_share_link(
  req,
  path,
  password = NULL,
  permissions = 1,
  public_upload = FALSE,
  expire_date = NULL,
  note = "",
  label = ""
)

ocs_create_share_mail(
  req,
  path,
  email,
  password = NULL,
  permissions = 1,
  public_upload = FALSE,
  expire_date = NULL,
  note = "",
  label = "",
  send_mail = TRUE
)

ocs_create_share_user(
  req,
  path,
  user,
  permissions = 1,
  public_upload = FALSE,
  expire_date = NULL,
  note = "",
  label = "",
  send_mail = TRUE
)

ocs_create_share_group(
  req,
  path,
  group,
  permissions = 1,
  public_upload = FALSE,
  expire_date = NULL,
  note = "",
  label = "",
  send_mail = TRUE
)

ocs_create_share_federated(
  req,
  path,
  cloud_id,
  permissions = 1,
  public_upload = FALSE,
  expire_date = NULL,
  note = "",
  label = "",
  send_mail = TRUE
)
}
\arguments{
\item{req}{WebDAV request as returned by \code{\link{wd_connect}}}

\item{path}{folder or file path}

\item{share_type}{integer 0:user, 1:group, 3:link, 4:e-mail, 6:federated}

\item{share_with}{depending on share type: user id, group id,
e-mail address or federated cloud id (only for \code{ocs_create_share})}

\item{password}{optional password for link and e-mail shares}

\item{permissions}{integer or char vector
(1:read, 2:update, 4:create, 8:delete, 16:share), default is 1:read}

\item{public_upload}{TRUE if public upload should be enabled}

\item{expire_date}{expiration date as string in the format YYYY-MM-DD}

\item{label}{label for the share}

\item{note}{note for the share}

\item{send_mail}{if TRUE the user is notified via e-mail}

\item{attributes}{optional attributes}

\item{email}{e-mail address  (only for \code{ocs_create_share_mail})}

\item{user}{id of the user (only for \code{ocs_create_share_user})}

\item{group}{id of the group (only for \code{ocs_create_share_group})}

\item{cloud_id}{cloud id (only for \code{ocs_create_share_federated})}
}
\value{
information for the newly created share as data.frame
}
\description{
Creates different share types:
}
\details{
\itemize{
\item \code{ocs_create_share} - generic method that takes share type as argument
\item \code{ocs_create_share_user} - creates a share for a nextcloud user
\item \code{ocs_create_share_group} - creates a share for a nextcloud group
\item \code{ocs_create_share_link} - create a public share link
\item \code{ocs_create_share_mail} - creates an e-mail share
\item \code{ocs_create_share_federated} - creates a federated share
}

Notice: if protecting a public link or e-mail share with a password, make
sure that the password meets the services' password policy.

Share permissions can be given as vector of integers or characters,
e.g. \code{c(1, 2, 8)} or \code{c("read", "update", "delete")}, or as their sum or
concatenation, e.g. \code{11} or \code{"read,update,delete"}.
}
\examples{
\dontrun{
r <- wd_connect("https://example.com/remote.php/dav/files/johndoe")
ocs_create_share(r, "myfolder/share", 4)
ocs_create_share_link(r, "myfolder/share")
ocs_create_share_mail(r, "myfolder/share", "jack@example.com")
ocs_create_share_user(r, "myfolder/share", "jackdoe", c("read", "update"))

}

}
