% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{html_dependency_mobx}
\alias{html_dependency_mobx}
\title{Dependencies for 'mobx'}
\usage{
html_dependency_mobx(react = TRUE)
}
\arguments{
\item{react}{\code{logical} to add react 'mobx' dependencies.}
}
\value{
\code{\link[htmltools]{htmlDependency}}
}
\description{
Add JavaScript 'mobx' and 'mobx-react' dependency.  When using with 'react', the order
of the dependencies is important, so please add \code{html_dependency_react()} before
\code{html_dependency_mobx()}.
}
\examples{
if(interactive()) {

library(htmltools)
library(reactR)

browsable(
  tagList(
    html_dependency_mobx(react = FALSE),
    div(id="test"),
    tags$script(HTML(
"
  var obs = mobx.observable({val: null})
  mobx.autorun(function() {
    document.querySelector('#test').innerText = obs.val
  })
  setInterval(
    function() {obs.val++},
    1000
  )
"
    ))
  )
)
}

\dontrun{
# use with react
library(htmltools)
library(reactR)

browsable(
  tagList(
    html_dependency_react(),
    html_dependency_mobx(),
    div(id="test"),
    tags$script(HTML(babel_transform(
"
  var obs = mobx.observable({val: null})
  var App = mobxReact.observer((props) => <div>{props.obs.val}</div>)

  ReactDOM.render(<App obs = {obs}/>, document.querySelector('#test'))

  setInterval(
    function() {obs.val++},
    1000
  )
"
    )))
  )
)
}
}
