% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/reader.R
\name{n.readLines}
\alias{n.readLines}
\title{Read 'n' lines (ignoring comments and header) from a file.}
\usage{
n.readLines(fn, n, comment = "#", skip = 0, header = TRUE)
}
\arguments{
\item{fn}{name of the file(s) to get the length of}

\item{n}{number of valid lines to attempt to read
looks at the top few lines (ignoring comments)}

\item{comment}{a comment symbol to ignore lines in files}

\item{skip}{number of lines to skip at top of file before processing}

\item{header}{whether to allow for, and skip, a header row}
}
\value{
returns the first n lines of the file meeting the criteria,
 or if 'skip' implies lines beyond the length of the file, the
 result,will be truncated - although in this case, the last
 line will always be read.
}
\description{
Useful when you don't know the length/structure of a file
and want a useful sample to look at. Can skip ahead in the file too.
Copes well when there are less than 'n' lines in the file.
}
\examples{
orig.dir <- getwd(); setwd(tempdir()); # move to temporary dir
dat <- matrix(sample(100),nrow=10)
write.table(dat,"temp.txt",col.names=FALSE,row.names=FALSE)
n.readLines("temp.txt",n=2,skip=2,header=FALSE)
dat[3:4,]
unlink("temp.txt")
setwd(orig.dir) # reset working directory to original
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}

