% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETM.R
\name{ETM}
\alias{ETM}
\alias{dETM}
\alias{pETM}
\alias{rETM}
\title{Exponential Threshold Model}
\usage{
dETM(rt, resp, phi, x_res = "default", t_res = "default")

pETM(rt, resp, phi, x_res = "default", t_res = "default")

rETM(n, phi, dt = 1e-05)
}
\arguments{
\item{rt}{vector of response times}

\item{resp}{vector of responses ("upper" and "lower")}

\item{phi}{parameter vector in the following order:
\enumerate{
\item Non-decision time (\eqn{t_{nd}}). Time for non-decision processes such as stimulus
encoding and response execution. Total decision time t is the sum of the decision
and non-decision times.
\item Relative start (\eqn{w}). Sets the start point of accumulation as a ratio of
the two decision thresholds. Related to the absolute start z point via equation
\eqn{z = b_l + w*(b_u - b_l)}.
\item Stimulus strength (\eqn{\mu}). Strength of the stimulus and used to set the drift
rate. For changing threshold models \eqn{v(x,t) = \mu}.
\item Noise scale (\eqn{\sigma}). Model noise scale parameter.
\item Initial decision threshold location (\eqn{b_0}). Sets the location of each decision
threshold at time \eqn{t = 0}.
\item Log10-rate of threshold change (\eqn{log_{10}(\tau)}).
\item Contamination (\eqn{g}). Sets the strength of the contamination process. Contamination
process is a uniform distribution \eqn{f_c(t)} where \eqn{f_c(t) = 1/(g_u-g_l)}
if \eqn{g_l <= t <= g_u} and \eqn{f_c(t) = 0} if \eqn{t < g_l} or \eqn{t > g_u}. It is
combined with PDF \eqn{f_i(t)} to give the final combined distribution
\eqn{f_{i,c}(t) = g*f_c(t) + (1-g)*f_i(t)}, which is then output by the program.
If \eqn{g = 0}, it just outputs \eqn{f_i(t)}.
\item Lower bound of contamination distribution (\eqn{g_l}). See parameter \eqn{g}.
\item Upper bound of contamination distribution (\eqn{g_u}). See parameter \eqn{g}.
}}

\item{x_res}{spatial/evidence resolution}

\item{t_res}{time resolution}

\item{n}{number of samples}

\item{dt}{step size of time. We recommend 0.00001 (1e-5)}
}
\value{
For the density a list of PDF values, log-PDF values, and the sum of the
log-PDFs, for the distribution function a list of of CDF values, log-CDF values,
and the sum of the log-CDFs, and for the random sampler a list of response
times (rt) and response thresholds (resp).
}
\description{
SDDM with thresholds that change with time. Thresholds are symmetric exponential functions
of the form \eqn{b_u(t) = -b_l(t) = b_0*exp(-t/\tau)}.
}
\examples{
# Probability density function
dETM(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(0.3, 0.5, 1.0, 1.0, 1.5, 0.5, 0.0, 0.0, 1.0))

# Cumulative distribution function
pETM(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(0.3, 0.5, 1.0, 1.0, 1.5, 0.5, 0.0, 0.0, 1.0))

# Random sampling
rETM(n = 100, phi = c(0.3, 0.5, 1.0, 1.0, 1.5, 0.5, 0.0, 0.0, 1.0))
}
\references{
Murrow, M., & Holmes, W. R. (2023). PyBEAM: A Bayesian approach to parameter inference
for a wide class of binary evidence accumulation models. \emph{Behavior Research
Methods, 56}(3), 2636-2656.
}
\author{
Raphael Hartmann & Matthew Murrow
}
