% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fosr.vs.R
\name{fosr.vs}
\alias{fosr.vs}
\title{Function-on Scalar Regression with variable selection}
\usage{
fosr.vs(formula, data, nbasis = 10, method = c("ls", "grLasso", "grMCP",
  "grSCAD"), epsilon = 1e-05, max.iter_num = 100)
}
\arguments{
\item{formula}{an object of class "\code{\link{formula}}": an expression of the model to be fitted.}

\item{data}{a data frame that contains the variables in the model.}

\item{nbasis}{number of B-spline basis functions used.}

\item{method}{group variable selection method to be used ("grLasso", "grMCP", "grSCAD" refer to group Lasso, group MCP and group SCAD, respectively) or "\code{ls}" for least squares estimation.}

\item{epsilon}{the convergence criterion.}

\item{max.iter_num}{maximum number of iterations.}
}
\value{
A fitted fosr.vs-object, which is a list with the following elements:
\item{formula}{an object of class "\code{\link{formula}}": an expression of the model to be fitted.}
\item{coefficients}{the estimated coefficient functions.}
\item{fitted.values}{the fitted curves.}
\item{residuals}{the residual curves.}
\item{vcov}{the estimated variance-covariance matrix when convergence is achieved.}
\item{method}{group variable selection method to be used or "\code{ls}" for least squares estimation.}
}
\description{
Implements an iterative algorithm for function-on-scalar regression with variable selection
by alternatively updating the coefficients and covariance structure.
}
\examples{
\dontrun{
set.seed(100)

I = 100
p = 20
D = 50
grid = seq(0, 1, length = D)

beta.true = matrix(0, p, D)
beta.true[1,] = sin(2*grid*pi)
beta.true[2,] = cos(2*grid*pi)
beta.true[3,] = 2

psi.true = matrix(NA, 2, D)
psi.true[1,] = sin(4*grid*pi)
psi.true[2,] = cos(4*grid*pi)
lambda = c(3,1)

set.seed(100)

X = matrix(rnorm(I*p), I, p)
C = cbind(rnorm(I, mean = 0, sd = lambda[1]), rnorm(I, mean = 0, sd = lambda[2]))

fixef = X\%*\%beta.true
pcaef = C \%*\% psi.true
error = matrix(rnorm(I*D), I, D)

Yi.true = fixef
Yi.pca = fixef + pcaef
Yi.obs = fixef + pcaef + error

data = as.data.frame(X)
data$Y = Yi.obs
fit.fosr.vs = fosr.vs(Y~., data = data, method="grMCP")
plot(fit.fosr.vs)
}


}
\references{
Chen, Y., Goldsmith, J., and Ogden, T. (2016).
Variable selection in function-on-scalar regression. \emph{Stat} 5 88-101
}
\seealso{
\code{\link{grpreg}}
}
\author{
Yakuan Chen \email{yc2641@cumc.columbia.edu}
}
