% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_var.R
\name{nice_var}
\alias{nice_var}
\title{Obtain variance per group}
\usage{
nice_var(data, variable, group, criteria = 4)
}
\arguments{
\item{data}{The data frame}

\item{variable}{The dependent variable to be plotted.}

\item{group}{The group by which to plot the variable.}

\item{criteria}{Desired threshold if one wants something
different than four times the variance.}
}
\value{
A dataframe, with the values of the selected variables for
each group, their max variance ratio (maximum variance divided by
the minimum variance), the selected decision criterion, and whether
the data are considered heteroscedastic according to the decision
criterion.
}
\description{
Obtain variance per group as well as check for
the rule of thumb of one group having variance four times
bigger than any of the other groups. Variance ratio is
calculated as Max / Min.
}
\examples{
# Make the basic table
nice_var(
  data = iris,
  variable = "Sepal.Length",
  group = "Species"
)

# Try on multiple variables
nice_var(
  data = iris,
  variable = names(iris[1:4]),
  group = "Species"
)

}
\seealso{
Other functions useful in assumption testing:
\code{\link{nice_assumptions}}, \code{\link{nice_density}},
\code{\link{nice_normality}}, \code{\link{nice_qq}},
\code{\link{nice_varplot}}. Tutorial:
\url{https://rempsyc.remi-theriault.com/articles/assumptions}
}
\keyword{variance}
