% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xrefs_utils.R
\name{split_anchor}
\alias{split_anchor}
\title{Resolve links}
\usage{
split_anchor(links, count = TRUE)
}
\arguments{
\item{links}{A data.frame with Package, Source, Anchor and Target.}

\item{count}{A logical value if links should be counted.}
}
\value{
A data.frame with Package, Source, to_pkg, to_target, n (number of times it happens)
}
\description{
Converts Anchors and targets so that it can be easily understood.
See \href{https://cran.r-project.org/doc/manuals/r-devel/R-exts.html#Cross_002dreferences}{WRE}
for extensive explanations
}
\details{
There are 4 different types of links:
\itemize{
\item \code{{Target}}
\item \verb{[=Target]\{name\}}
\item \verb{[package]\{Target\}}
\item \verb{[package:target]\{name\}}
The first two can be to any package and led to disambiguation pages, the last
two are fully resolved (package and alias)
}
}
\seealso{
\code{\link[=targets2files]{targets2files()}}
}
\keyword{internal}
