% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-vector-methods.R
\name{ComplexPolynomial}
\alias{ComplexPolynomial}
\title{Vector Representation: Complex Polynomial}
\description{
Computes complex polynomials from a list of persistence
diagrams. The persistence diagram points are seen as the roots of some
complex polynomial, whose coefficients are returned in a complex vector.
See https://link.springer.com/chapter/10.1007\%2F978-3-319-23231-7_27 for
more details.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new(use = TRUE)
dgm <- ds$apply(dgm)
cp <- ComplexPolynomial$new()
cp$apply(dgm)
cp$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:VectorRepresentationStep]{rgudhi::VectorRepresentationStep}} -> \code{ComplexPolynomial}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ComplexPolynomial-new}{\code{ComplexPolynomial$new()}}
\item \href{#method-ComplexPolynomial-clone}{\code{ComplexPolynomial$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="apply"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-apply'><code>rgudhi::VectorRepresentationStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="fit"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-fit'><code>rgudhi::VectorRepresentationStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="fit_transform"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-fit_transform'><code>rgudhi::VectorRepresentationStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="transform"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-transform'><code>rgudhi::VectorRepresentationStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ComplexPolynomial-new"></a>}}
\if{latex}{\out{\hypertarget{method-ComplexPolynomial-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{ComplexPolynomial}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ComplexPolynomial$new(polynomial_type = c("R", "S", "T"), threshold = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{polynomial_type}}{A string specifying the Type of complex polynomial
that is going to be computed (explained in
https://link.springer.com/chapter/10.1007\%2F978-3-319-23231-7_27).
Choices are \code{c("R", "S", "T")}. Defaults to \code{"R"}.}

\item{\code{threshold}}{An integer value specifying the number of coefficients.
This is the dimension of the complex vector of coefficients, i.e. the
number of coefficients corresponding to the largest degree terms of the
polynomial. If \code{-1}, this threshold is computed from the list of
persistence diagrams by considering the one with the largest number of
points and using the dimension of its corresponding complex vector of
coefficients as threshold. Defaults to \code{10L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{ComplexPolynomial}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ComplexPolynomial-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ComplexPolynomial-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ComplexPolynomial$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
