% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklearn-cluster.R
\name{DBSCAN}
\alias{DBSCAN}
\title{Performs clustering according to the DBSCAN algorithm}
\description{
DBSCAN - Density-Based Spatial Clustering of Applications with Noise. Finds core samples of high density and expands clusters from them. Good for data which contains clusters of similar density. This is a wrapper around the Python class
\href{https://scikit-learn.org/stable/modules/generated/sklearn.cluster.DBSCAN.html#sklearn.cluster.DBSCAN}{sklearn.cluster.DBSCAN}.
}
\examples{
\dontshow{if (reticulate::py_module_available("sklearn.cluster")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cl <- DBSCAN$new()
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Ester, M., H. P. Kriegel, J. Sander, and X. Xu (1996). \emph{A Density-Based
Algorithm for Discovering Clusters in Large Spatial Databases with Noise},
In: Proceedings of the 2nd International Conference on Knowledge Discovery
and Data Mining, Portland, OR, AAAI Press, pp. 226-231.
\item Schubert, E., Sander, J., Ester, M., Kriegel, H. P., & Xu, X. (2017).
\emph{DBSCAN revisited, revisited: why and how you should (still) use DBSCAN}, ACM
Transactions on Database Systems (TODS), \strong{42}(3), p. 19.
}
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:BaseClustering]{rgudhi::BaseClustering}} -> \code{DBSCAN}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DBSCAN-new}{\code{DBSCAN$new()}}
\item \href{#method-DBSCAN-clone}{\code{DBSCAN$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="apply"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-apply'><code>rgudhi::SKLearnClass$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit'><code>rgudhi::SKLearnClass$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit_transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit_transform'><code>rgudhi::SKLearnClass$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-transform'><code>rgudhi::SKLearnClass$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DBSCAN-new"></a>}}
\if{latex}{\out{\hypertarget{method-DBSCAN-new}{}}}
\subsection{Method \code{new()}}{
The \link{DBSCAN} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBSCAN$new(
  eps = 0.5,
  min_samples = 5L,
  metric = "euclidean",
  metric_params = NULL,
  algorithm = c("auto", "ball_tree", "kd_tree", "brute"),
  leaf_size = 30L,
  p = 2L,
  n_jobs = 1L
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{eps}}{A numeric value specifying the maximum distance between two
samples for one to be considered as in the neighborhood of the other.
This is not a maximum bound on the distances of points within a
cluster. This is the most important DBSCAN parameter to choose
appropriately for your data set and distance function. Defaults to
\code{0.5}.}

\item{\code{min_samples}}{An integer value specifying the number of samples (or
total weight) in a neighborhood for a point to be considered as a core
point. This includes the point itself. Defaults to \code{5L}.}

\item{\code{metric}}{Either a string or an object coercible into a function via
\code{\link[rlang:as_function]{rlang::as_function()}} specifying the metric to use when calculating
distance between instances in a feature array. If \code{metric} is a string,
it must be one of the options allowed by
\href{https://scikit-learn.org/stable/modules/generated/sklearn.metrics.pairwise_distances.html#sklearn.metrics.pairwise_distances}{sklearn.metrics.pairwise_distances}
for its \code{metric} parameter. If \code{metric} is \code{"precomputed"}, \code{X} is
assumed to be a distance matrix and must be square. \code{X} may be a sparse
graph, in which case only \emph{nonzero} elements may be considered
neighbors for DBSCAN. Defaults to \code{"euclidean"}.}

\item{\code{metric_params}}{A named list specifying additional parameters to be
passed on to the metric function. Defaults to \code{NULL}.}

\item{\code{algorithm}}{A string specifying the algorithm to be used by the
\href{https://scikit-learn.org/stable/modules/classes.html#module-sklearn.neighbors}{sklearn.neighbors.NearestNeighbors}
module to compute pointwise distances and find nearest neighbors.
Choices are \code{"auto"}, \code{"ball_tree"}, \code{"kd_tree"} or \code{"brute"}. Defaults
to \code{"auto"}.}

\item{\code{leaf_size}}{An integer value specifying the leaf size passed to
\href{https://scikit-learn.org/stable/modules/generated/sklearn.neighbors.BallTree.html}{sklearn.neighbors.BallTree}
or
\href{https://scikit-learn.org/stable/modules/generated/sklearn.neighbors.KDTree.html#sklearn.neighbors.KDTree}{sklearn.neighbors.KDTree}.
This can affect the speed of the construction and query, as well as the
memory required to store the tree. The optimal value depends on the
nature of the problem. Defaults to \code{30L}.}

\item{\code{p}}{An integer value specifying the power of the Minkowski metric to
be used to calculate distance between points. Defaults to \code{2L}.}

\item{\code{n_jobs}}{An integer value specifying the number of parallel jobs to
run. Defaults to \code{1L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{DBSCAN}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DBSCAN-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DBSCAN-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBSCAN$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
