% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-metrics.R
\name{MetricStep}
\alias{MetricStep}
\title{Metric Step}
\description{
Metric Step

Metric Step
}
\author{
Mathieu Carrière
}
\keyword{internal}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{MetricStep}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MetricStep-apply}{\code{MetricStep$apply()}}
\item \href{#method-MetricStep-fit}{\code{MetricStep$fit()}}
\item \href{#method-MetricStep-transform}{\code{MetricStep$transform()}}
\item \href{#method-MetricStep-fit_transform}{\code{MetricStep$fit_transform()}}
\item \href{#method-MetricStep-clone}{\code{MetricStep$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetricStep-apply"></a>}}
\if{latex}{\out{\hypertarget{method-MetricStep-apply}{}}}
\subsection{Method \code{apply()}}{
Applies the class on a single persistence diagram and
outputs the result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetricStep$apply(diag1, diag2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{diag1}}{A 2-column \link[tibble:tibble]{tibble::tibble} specifying a persistence diagram.}

\item{\code{diag2}}{A 2-column \link[tibble:tibble]{tibble::tibble} specifying a persistence diagram.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric value storing the distance between the two input
diagrams.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetricStep-fit"></a>}}
\if{latex}{\out{\hypertarget{method-MetricStep-fit}{}}}
\subsection{Method \code{fit()}}{
Fits the class on a sample of persistence diagrams.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetricStep$fit(X, y = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{A list of 2-column \link[tibble:tibble]{tibble::tibble}s specifying a sample of
persistence diagrams.}

\item{\code{y}}{An integer vector specifying persistence diagram labels (unused for
now).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The class itself invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetricStep-transform"></a>}}
\if{latex}{\out{\hypertarget{method-MetricStep-transform}{}}}
\subsection{Method \code{transform()}}{
Applies the class on a sample of persistence diagrams.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetricStep$transform(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{A list of 2-column \link[tibble:tibble]{tibble::tibble}s specifying a sample of
persistence diagrams.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric matrix of shape \eqn{n_\mathrm{out} \times
  n_\mathrm{in}} storing the distances between the \eqn{n_\mathrm{out}}
persistence diagrams passed to the \verb{$transform()} method and the
\eqn{n_\mathrm{in}} persistence diagrams passed to the \verb{$fit()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetricStep-fit_transform"></a>}}
\if{latex}{\out{\hypertarget{method-MetricStep-fit_transform}{}}}
\subsection{Method \code{fit_transform()}}{
Applies sequentially the \verb{$fit()} and \verb{$transform()} methods
on a sample of persistence diagrams in a more efficient way than
calling them directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetricStep$fit_transform(X, y = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{A list of 2-column \link[tibble:tibble]{tibble::tibble}s specifying a sample of
persistence diagrams.}

\item{\code{y}}{An integer vector specifying persistence diagram labels (unused for
now).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric matrix of shape \eqn{n \times n} storing the distance
between the \eqn{n} persistence diagrams passed to both the \verb{$fit()}
and \verb{$transform()} methods.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetricStep-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MetricStep-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetricStep$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
