% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_linters.R
\name{box_func_import_count_linter}
\alias{box_func_import_count_linter}
\title{\code{box} library function import count linter}
\usage{
box_func_import_count_linter(max = 8L)
}
\arguments{
\item{max}{Maximum function imports allowed between \code{[} and \verb{]}. Defaults to 8.}
}
\value{
A custom linter function for use with \code{r-lib/lintr}.
}
\description{
Checks that function imports do not exceed the defined \code{max}.
See the \href{https://appsilon.github.io/rhino/articles/explanation/rhino-style-guide.html}{Explanation: Rhino style guide}
to learn about the details.
}
\examples{
# will produce lints
lintr::lint(
  text = "box::use(package[one, two, three, four, five, six, seven, eight, nine])",
  linters = box_func_import_count_linter()
)

lintr::lint(
  text = "box::use(package[one, two, three, four])",
  linters = box_func_import_count_linter(3)
)

# okay
lintr::lint(
  text = "box::use(package[one, two, three, four, five])",
  linters = box_func_import_count_linter()
)

lintr::lint(
  text = "box::use(package[one, two, three])",
  linters = box_func_import_count_linter(3)
)

}
