% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_linters.R
\name{box_universal_import_linter}
\alias{box_universal_import_linter}
\title{\code{box} library universal import linter}
\usage{
box_universal_import_linter()
}
\value{
A custom linter function for use with \code{r-lib/lintr}
}
\description{
Checks that all function imports are explicit. \code{package[...]} is not used.
See the \href{https://appsilon.github.io/rhino/articles/explanation/rhino-style-guide.html}{Explanation: Rhino style guide}
to learn about the details.
}
\examples{
# will produce lints
lintr::lint(
  text = "box::use(base[...])",
  linters = box_universal_import_linter()
)

lintr::lint(
  text = "box::use(path/to/file[...])",
  linters = box_universal_import_linter()
)

# okay
lintr::lint(
  text = "box::use(base[print])",
  linters = box_universal_import_linter()
)

lintr::lint(
  text = "box::use(path/to/file[do_something])",
  linters = box_universal_import_linter()
)

}
