% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inat_obs_project.R
\name{get_inat_obs_project}
\alias{get_inat_obs_project}
\title{Download observations or info from a project}
\usage{
get_inat_obs_project(grpid, type = c("observations", "info"), raw = FALSE)
}
\arguments{
\item{grpid}{Name of the group as an iNaturalist slug or group ID.}

\item{type}{Character, either "observations" or "info". "observations" returns all observations, and "info" returns project details similar to what you can find on a project's page.}

\item{raw}{Logical. If TRUE and searching for project info, returns the raw output of parsed JSON for that project. Otherwise just some basic information is returned as a list.}
}
\description{
Retrieve observations from a particular iNaturalist project. This function can be used to get either observations or information from a project by project name or ID.
}
\details{
An iNaturalist slug is usually the project name as a single string with words separated by hyphens. For instance, the project "World Oceans Week 2022" has a slug of "world-oceans-week-2022", which you can find by searching projects on iNaturalist and looking at the \href{https://www.inaturalist.org/projects/world-oceans-week-2022}{project's page's URL}.
}
\examples{
\dontrun{
 get_inat_obs_project(354, type = "observations")
 get_inat_obs_project("crows-in-vermont", type="info",raw=FALSE)
}
}
